/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.convenientdecor.client.render.umbrella;

import com.github.mim1q.convenientdecor.ConvenientDecor;
import com.github.mim1q.convenientdecor.client.render.umbrella.UmbrellaModel;
import com.github.mim1q.convenientdecor.init.ModBlocks;
import com.github.mim1q.convenientdecor.init.ModEntityModelLayers;
import com.github.mim1q.convenientdecor.init.ModItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_5601;

public class UmbrellaRenderer {
    public static final Map<class_1767, class_2960> TEXTURES = new HashMap<class_1767, class_2960>();
    private final class_2960 textureOverride;
    private final UmbrellaModel foldedModel;
    private final UmbrellaModel unfoldedModel;

    private UmbrellaRenderer(class_5599 loader) {
        this(loader, null);
    }

    private UmbrellaRenderer(class_5599 loader, class_2960 texture) {
        this.foldedModel = new UmbrellaModel(loader.method_32072(ModEntityModelLayers.UMBRELLA_FOLDED));
        this.unfoldedModel = new UmbrellaModel(loader.method_32072(ModEntityModelLayers.UMBRELLA_UNFOLDED));
        this.textureOverride = texture;
    }

    private UmbrellaRenderer(class_5599 loader, class_5601 foldedLayer, class_5601 unfoldedLayer, class_2960 texture) {
        this.foldedModel = new UmbrellaModel(loader.method_32072(foldedLayer));
        this.unfoldedModel = new UmbrellaModel(loader.method_32072(unfoldedLayer));
        this.textureOverride = texture;
    }

    public class_2960 getTexture(class_1767 color) {
        return this.textureOverride == null ? TEXTURES.get(color) : this.textureOverride;
    }

    public void render(class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, class_1767 color, boolean folded) {
        UmbrellaModel model = folded ? this.foldedModel : this.unfoldedModel;
        class_4588 consumer = vertexConsumers.getBuffer(model.method_23500(this.getTexture(color)));
        model.method_2828(matrices, consumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    static {
        for (class_1767 color : class_1767.values()) {
            TEXTURES.put(color, ConvenientDecor.id("textures/blockentity/umbrella/" + color.method_7792() + ".png"));
        }
    }

    public static class UmbrellaRenderHelper {
        public static final class_2960 BROKEN_TEXTURE = ConvenientDecor.id("textures/blockentity/umbrella/broken.png");
        public static final class_2960 ALLERTS_UMBRELLA_TEXTURE = ConvenientDecor.id("textures/blockentity/umbrella/allert.png");
        private final UmbrellaRenderer defaultRenderer;
        private final UmbrellaRenderer brokenRenderer;
        private final UmbrellaRenderer allertsRenderer;

        public UmbrellaRenderHelper(class_5599 loader) {
            this.defaultRenderer = new UmbrellaRenderer(loader);
            this.brokenRenderer = new UmbrellaRenderer(loader, BROKEN_TEXTURE);
            this.allertsRenderer = new UmbrellaRenderer(loader, ModEntityModelLayers.ALLERTS_UMBRELLA_FOLDED, ModEntityModelLayers.ALLERTS_UMBRELLA_UNFOLDED, ALLERTS_UMBRELLA_TEXTURE);
        }

        public UmbrellaRenderer getRenderer(class_1799 stack) {
            if (stack.method_31574((class_1792)ModItems.BROKEN_UMBRELLA)) {
                return this.brokenRenderer;
            }
            if (stack.method_31574((class_1792)ModItems.ALLERTS_UMBRELLA)) {
                return this.allertsRenderer;
            }
            return this.defaultRenderer;
        }

        public UmbrellaRenderer getRenderer(class_2680 state) {
            if (state.method_27852((class_2248)ModBlocks.BROKEN_UMBRELLA)) {
                return this.brokenRenderer;
            }
            if (state.method_27852((class_2248)ModBlocks.ALLERTS_UMBRELLA)) {
                return this.allertsRenderer;
            }
            return this.defaultRenderer;
        }
    }
}

