/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui.widgets;

import com.gitlab.cdagaming.unilib.utils.gui.RenderUtils;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedTextControl;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import io.github.cdagaming.unicore.utils.StringUtils;
import net.minecraft.class_327;

public class TextWidget
extends ExtendedTextControl {
    private String title;
    private int titleLeft;
    private int titleRight;
    private boolean setDimensions = false;
    private Runnable titleHoverEvent = null;

    public TextWidget(int componentId, class_327 fontRendererObj, int y, int widthIn, int heightIn, String title, Runnable titleHoverEvent) {
        super(componentId, fontRendererObj, 0, y, widthIn, heightIn);
        this.setTitle(title);
        this.setOnTitleHover(titleHoverEvent);
    }

    public TextWidget(int componentId, class_327 fontRendererObj, int y, int widthIn, int heightIn, String title) {
        this(componentId, fontRendererObj, y, widthIn, heightIn, title, null);
    }

    public TextWidget(class_327 fontRendererObj, int y, int widthIn, int heightIn, String title, Runnable titleHoverEvent) {
        super(fontRendererObj, 0, y, widthIn, heightIn);
        this.setTitle(title);
        this.setOnTitleHover(titleHoverEvent);
    }

    public TextWidget(class_327 fontRendererObj, int y, int widthIn, int heightIn, String title) {
        this(fontRendererObj, y, widthIn, heightIn, title, null);
    }

    public TextWidget(class_327 fontRendererObj, int y, int widthIn, int heightIn, Runnable keyEvent, String title, Runnable titleHoverEvent) {
        super(fontRendererObj, 0, y, widthIn, heightIn, keyEvent);
        this.setTitle(title);
        this.setOnTitleHover(titleHoverEvent);
    }

    public TextWidget(class_327 fontRendererObj, int y, int widthIn, int heightIn, Runnable keyEvent, String title) {
        this(fontRendererObj, y, widthIn, heightIn, keyEvent, title, null);
    }

    public boolean hasTitle() {
        return !StringUtils.isNullOrEmpty(this.getTitle());
    }

    public String getTitle() {
        return this.title;
    }

    public TextWidget setTitle(String title) {
        this.title = title;
        return this;
    }

    public void setOnTitleHover(Runnable event) {
        this.titleHoverEvent = event;
    }

    public void onTitleHover() {
        if (this.titleHoverEvent != null) {
            this.titleHoverEvent.run();
        }
    }

    @Override
    public void preDraw(ExtendedScreen screen) {
        if (!this.setDimensions) {
            int middle = screen.getScreenWidth() / 2;
            this.setControlPosX(middle + 3);
            this.titleLeft = middle - 180;
            this.titleRight = middle - 6;
            this.setDimensions = true;
        }
        super.preDraw(screen);
    }

    @Override
    public void draw(ExtendedScreen screen) {
        if (this.hasTitle() && this.setDimensions) {
            String mainTitle = this.getTitle();
            screen.renderScrollingString(mainTitle, this.titleLeft + screen.getStringWidth(mainTitle) / 2, this.titleLeft, this.getTop(), this.titleRight, this.getBottom(), 0xFFFFFF);
        }
        super.draw(screen);
    }

    @Override
    public void postDraw(ExtendedScreen screen) {
        if (this.hasTitle() && this.setDimensions && screen.isOverScreen() && RenderUtils.isMouseOver(screen.getMouseX(), screen.getMouseY(), this.titleLeft, this.getTop(), this.titleRight - this.titleLeft, this.getControlHeight())) {
            this.onTitleHover();
        }
        super.postDraw(screen);
    }
}

