/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.items.magnetic_compass;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4208;
import net.minecraft.class_638;
import net.minecraft.class_6395;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class MagneticCompassItemPropertyFunction
implements class_6395 {
    public static final int DEFAULT_ROTATION = 0;
    private final CompassWobble wobble = new CompassWobble();
    private final CompassWobble wobbleRandom = new CompassWobble();
    public final CompassTarget compassTarget;

    public MagneticCompassItemPropertyFunction(CompassTarget compassTarget) {
        this.compassTarget = compassTarget;
    }

    public float unclampedCall(class_1799 itemStack, @Nullable class_638 clientLevel, @Nullable class_1309 livingEntity, int i) {
        class_1309 entity;
        Object object = entity = livingEntity != null ? livingEntity : itemStack.method_27319();
        if (entity == null) {
            return 0.0f;
        }
        return (clientLevel = this.tryFetchLevelIfMissing((class_1297)entity, clientLevel)) == null ? 0.0f : this.getCompassRotation(itemStack, clientLevel, i, (class_1297)entity);
    }

    private float getCompassRotation(class_1799 itemStack, class_638 clientLevel, int i, class_1297 entity) {
        class_4208 globalPos = this.compassTarget.getPos(clientLevel, itemStack, entity);
        long l = clientLevel.method_8510();
        return !this.isValidCompassTargetPos(entity, globalPos) ? this.getRandomlySpinningRotation(i, l) : this.getRotationTowardsCompassTarget(entity, l, globalPos.method_19446());
    }

    private float getRandomlySpinningRotation(int i, long l) {
        if (this.wobbleRandom.shouldUpdate(l)) {
            this.wobbleRandom.update(l, Math.random());
        }
        double d = this.wobbleRandom.rotation + (double)((float)this.hash(i) / 2.1474836E9f);
        return class_3532.method_15341((float)((float)d), (float)1.0f);
    }

    private float getRotationTowardsNorth(class_1297 entity, long l) {
        class_1657 player;
        double d = this.getAngleFromEntityToNorth(entity);
        double e = this.getWrappedVisualRotationY(entity);
        if (entity instanceof class_1657 && (player = (class_1657)entity).method_7340()) {
            if (this.wobble.shouldUpdate(l)) {
                this.wobble.update(l, 0.5 - (e - 0.25));
            }
            double f = d + this.wobble.rotation;
            return class_3532.method_15341((float)((float)f), (float)1.0f);
        }
        double f = 0.5 - (e - 0.25 - d);
        return class_3532.method_15341((float)((float)f), (float)1.0f);
    }

    public float getRotationTowardsCompassTarget(class_1297 entity, long l, class_2338 blockPos) {
        class_1657 player;
        double d = this.getAngleFromEntityToPos(entity, blockPos);
        double e = this.getWrappedVisualRotationY(entity);
        if (entity instanceof class_1657 && (player = (class_1657)entity).method_7340()) {
            if (this.wobble.shouldUpdate(l)) {
                this.wobble.update(l, 0.5 - (e - 0.25));
            }
            double f = d + this.wobble.rotation;
            return class_3532.method_15341((float)((float)f), (float)1.0f);
        }
        double f = 0.5 - (e - 0.25 - d);
        return class_3532.method_15341((float)((float)f), (float)1.0f);
    }

    @Nullable
    private class_638 tryFetchLevelIfMissing(class_1297 entity, @Nullable class_638 clientLevel) {
        return clientLevel == null && entity.field_6002 instanceof class_638 ? (class_638)entity.field_6002 : clientLevel;
    }

    private boolean isValidCompassTargetPos(class_1297 entity, @Nullable class_4208 globalPos) {
        return globalPos != null && globalPos.method_19442() == entity.field_6002.method_27983() && !(globalPos.method_19446().method_19770((class_2374)entity.method_19538()) < (double)1.0E-5f);
    }

    private double getAngleFromEntityToPos(class_1297 entity, class_2338 blockPos) {
        class_243 vec3 = class_243.method_24953((class_2382)blockPos);
        return Math.atan2(vec3.method_10215() - entity.method_23321(), vec3.method_10216() - entity.method_23317()) / 6.2831854820251465;
    }

    private double getAngleFromEntityToNorth(class_1297 entity) {
        class_243 vec3 = class_243.method_24953((class_2382)entity.method_23312().method_10095());
        return Math.atan2(vec3.method_10215() - entity.method_23321(), vec3.method_10216() - entity.method_23317()) / 6.2831854820251465;
    }

    private double getWrappedVisualRotationY(class_1297 entity) {
        return class_3532.method_15367((double)(entity.method_43078() / 360.0f), (double)1.0);
    }

    private int hash(int i) {
        return i * 1327217883;
    }

    @Environment(value=EnvType.CLIENT)
    static class CompassWobble {
        double rotation;
        private double deltaRotation;
        private long lastUpdateTick;

        CompassWobble() {
        }

        boolean shouldUpdate(long l) {
            return this.lastUpdateTick != l;
        }

        void update(long l, double d) {
            this.lastUpdateTick = l;
            double e = d - this.rotation;
            e = class_3532.method_15367((double)(e + 0.5), (double)1.0) - 0.5;
            this.deltaRotation += e * 0.1;
            this.deltaRotation *= 0.8;
            this.rotation = class_3532.method_15367((double)(this.rotation + this.deltaRotation), (double)1.0);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static interface CompassTarget {
        @Nullable
        public class_4208 getPos(class_638 var1, class_1799 var2, class_1297 var3);
    }
}

