/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util;

import com.railwayteam.railways.util.fabric.RegistrationListeningImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class RegistrationListening {
    public static <T> void whenRegistered(class_2378<T> registry, class_2960 id, Consumer<T> consumer) {
        RegistrationListening.addListener(new Listener<T>(registry, id, consumer));
    }

    public static <T> void whenBothRegistered(class_2378<T> registry, class_2960 id1, class_2960 id2, BiConsumer<T, T> consumer) {
        RegistrationListening.whenBothRegistered(registry, id1, registry, id2, consumer);
    }

    public static <T, U> void whenBothRegistered(class_2378<T> registry1, class_2960 id1, class_2378<U> registry2, class_2960 id2, BiConsumer<T, U> consumer) {
        DualListener<T, U> dual = new DualListener<T, U>(registry1, id1, registry2, id2, consumer);
        RegistrationListening.addListener(dual.listener1);
        RegistrationListening.addListener(dual.listener2);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> void addListener(Listener<T> listener) {
        RegistrationListeningImpl.addListener(listener);
    }

    public record Listener<T>(class_2378<T> registry, class_2960 id, Consumer<T> consumer) {
        public void onRegister(T obj) {
            this.consumer.accept(obj);
        }
    }

    public static class DualListener<T, U> {
        public final Listener<T> listener1;
        public final Listener<U> listener2;
        private final BiConsumer<T, U> consumer;
        private T first;
        private U second;

        public DualListener(class_2378<T> registry1, class_2960 id1, class_2378<U> registry2, class_2960 id2, BiConsumer<T, U> consumer) {
            this.consumer = consumer;
            this.listener1 = new Listener<Object>(registry1, id1, this::firstRegistered);
            this.listener2 = new Listener<Object>(registry2, id2, this::secondRegistered);
        }

        private void firstRegistered(T first) {
            this.first = first;
            if (this.second != null) {
                this.bothRegistered();
            }
        }

        private void secondRegistered(U second) {
            this.second = second;
            if (this.first != null) {
                this.bothRegistered();
            }
        }

        private void bothRegistered() {
            this.consumer.accept(this.first, this.second);
        }
    }
}

