/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.cape.api;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.frozenblock.lib.FrozenSharedConstants;
import net.frozenblock.lib.cape.client.api.ClientCapeUtil;
import net.frozenblock.lib.cape.impl.Cape;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.NotNull;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.Unmodifiable;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class CapeUtil {
    private static final Map<class_2960, Cape> CAPES = new HashMap<class_2960, Cape>();
    private static final List<String> CAPE_REPOS = new ArrayList<String>();

    @NotNull
    public static @Unmodifiable List<String> getCapeRepos() {
        return ImmutableList.copyOf(CAPE_REPOS);
    }

    @NotNull
    public static @Unmodifiable Collection<Cape> getCapes() {
        return CAPES.values();
    }

    @NotNull
    public static @Unmodifiable List<Cape> getUsableCapes(UUID uuid) {
        return ImmutableList.copyOf(CapeUtil.getCapes().stream().filter(cape -> CapeUtil.canPlayerUserCape(uuid, cape)).toList());
    }

    public static Optional<Cape> getCape(class_2960 location) {
        return Optional.ofNullable(CAPES.get(location));
    }

    public static boolean canPlayerUserCape(UUID uuid, class_2960 capeID) {
        Optional<Cape> optionalCape = CapeUtil.getCape(capeID);
        return optionalCape.map(cape -> CapeUtil.canPlayerUserCape(uuid, cape)).orElse(true);
    }

    public static boolean canPlayerUserCape(UUID uuid, @NotNull Cape cape) {
        return cape.allowedPlayers().map(uuids -> uuids.contains(uuid)).orElse(true);
    }

    public static void registerCape(class_2960 id, class_2960 textureId, class_2561 capeName) {
        CAPES.put(id, new Cape(id, capeName, textureId, Optional.empty()));
    }

    public static void registerCape(class_2960 id, class_2561 capeName) {
        CAPES.put(id, new Cape(id, capeName, CapeUtil.buildCapeTextureLocation(id), Optional.empty()));
    }

    public static void registerCapeWithWhitelist(class_2960 id, class_2561 capeName, List<UUID> allowedPlayers) {
        CAPES.put(id, new Cape(id, capeName, CapeUtil.buildCapeTextureLocation(id), Optional.of(allowedPlayers)));
    }

    public static void registerCapeWithWhitelist(class_2960 id, class_2561 capeName, UUID ... uuids) {
        CAPES.put(id, new Cape(id, capeName, CapeUtil.buildCapeTextureLocation(id), Optional.of(ImmutableList.copyOf((Object[])uuids))));
    }

    public static void registerCapesFromURL(String urlString) {
        if (CAPE_REPOS.contains(urlString)) {
            return;
        }
        try {
            URL url = URI.create(urlString).toURL();
            URLConnection request = url.openConnection();
            request.connect();
            JsonElement parsedJson = JsonParser.parseReader((Reader)new InputStreamReader((InputStream)request.getContent()));
            JsonObject capeDir = parsedJson.getAsJsonObject();
            JsonArray capeArray = capeDir.get("capes").getAsJsonArray();
            capeArray.forEach(jsonElement -> CapeUtil.registerCapeFromURL(jsonElement.getAsString()));
            CAPE_REPOS.add(urlString);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void registerCapeFromURL(String urlString) {
        try {
            URL url = URI.create(urlString).toURL();
            URLConnection request = url.openConnection();
            request.connect();
            JsonElement parsedJson = JsonParser.parseReader((Reader)new InputStreamReader((InputStream)request.getContent()));
            JsonObject capeJson = parsedJson.getAsJsonObject();
            String capeId = capeJson.get("id").getAsString();
            class_5250 capeName = class_2561.method_43470((String)capeJson.get("name").getAsString());
            String capeTexture = capeJson.get("texture").getAsString();
            JsonElement allowedUUIDElement = capeJson.get("allowed_uuids");
            boolean whitelisted = allowedUUIDElement != null;
            class_2960 capeLocation = class_2960.method_12829((String)capeId);
            if (capeLocation != null) {
                class_2960 capeTextureLocation = CapeUtil.buildCapeTextureLocation(capeLocation);
                if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                    ClientCapeUtil.registerCapeTextureFromURL(capeLocation, capeTextureLocation, capeTexture);
                }
                if (!whitelisted) {
                    CapeUtil.registerCape(capeLocation, (class_2561)capeName);
                } else {
                    ArrayList uuidList = new ArrayList();
                    allowedUUIDElement.getAsJsonArray().asList().forEach(jsonElement -> uuidList.add(UUID.fromString(jsonElement.getAsString())));
                    CapeUtil.registerCapeWithWhitelist(capeLocation, (class_2561)capeName, (List<UUID>)ImmutableList.copyOf(uuidList));
                }
            }
        }
        catch (IOException ignored) {
            FrozenSharedConstants.LOGGER.error("Failed to parse Cape from URL: {}", (Object)urlString);
        }
    }

    public static class_2960 buildCapeTextureLocation(@NotNull class_2960 cape) {
        return class_2960.method_43902((String)cape.method_12836(), (String)("textures/cape/" + cape.method_12832() + ".png"));
    }
}

