/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.behaviors.PickupSink;
import appeng.api.behaviors.PickupStrategy;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.stacks.AEItemKey;
import appeng.core.AppEng;
import appeng.core.sync.packets.BlockTransitionEffectPacket;
import appeng.core.sync.packets.ItemTransitionEffectPacket;
import appeng.util.Platform;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class ItemPickupStrategy
implements PickupStrategy {
    public static final class_2960 TAG_BLACKLIST = new class_2960("ae2", "blacklisted/annihilation_plane");
    private static final class_6862<class_2248> BLOCK_BLACKLIST = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)TAG_BLACKLIST);
    private static final class_6862<class_1792> ITEM_BLACKLIST = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)TAG_BLACKLIST);
    private final class_3218 level;
    private final class_2338 pos;
    private final class_2350 side;
    private final Map<class_1887, Integer> enchantments;
    @Nullable
    private final UUID ownerUuid;
    private boolean isAccepting = true;

    public ItemPickupStrategy(class_3218 level, class_2338 pos, class_2350 side, class_2586 host, Map<class_1887, Integer> enchantments, @Nullable UUID owningPlayerId) {
        this.level = level;
        this.pos = pos;
        this.side = side;
        this.enchantments = enchantments;
        this.ownerUuid = owningPlayerId;
    }

    @Override
    public void reset() {
        this.isAccepting = true;
    }

    @Override
    public boolean canPickUpEntity(class_1297 entity) {
        return entity instanceof class_1542;
    }

    @Override
    public boolean pickUpEntity(IEnergySource energySource, PickupSink sink, class_1297 entity) {
        if (!this.isAccepting || !(entity instanceof class_1542)) {
            return false;
        }
        class_1542 itemEntity = (class_1542)entity;
        if (ItemPickupStrategy.isItemBlacklisted(itemEntity.method_6983().method_7909())) {
            return false;
        }
        boolean changed = this.storeEntityItem(sink, itemEntity);
        if (changed) {
            AppEng.instance().sendToAllNearExcept(null, this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260(), 64.0, (class_1937)this.level, new ItemTransitionEffectPacket(entity.method_23317(), entity.method_23318(), entity.method_23321(), this.side));
        }
        return true;
    }

    @Override
    public PickupStrategy.Result tryPickup(IEnergySource energySource, PickupSink sink) {
        class_2680 blockState;
        if (this.isAccepting && this.canHandleBlock(this.level, this.pos, blockState = this.level.method_8320(this.pos))) {
            List<class_1799> items = this.obtainBlockDrops(this.level, this.pos);
            float requiredPower = this.calculateEnergyUsage(this.level, this.pos, items);
            boolean hasPower = energySource.extractAEPower(requiredPower, Actionable.SIMULATE, PowerMultiplier.CONFIG) > (double)requiredPower - 0.1;
            boolean canStore = this.canStoreItemStacks(sink, items);
            if (hasPower && canStore) {
                this.completePickup(energySource, sink, items, requiredPower, blockState);
                return PickupStrategy.Result.PICKED_UP;
            }
            return PickupStrategy.Result.CANT_STORE;
        }
        return PickupStrategy.Result.CANT_PICKUP;
    }

    private void completePickup(IEnergySource energySource, PickupSink sink, List<class_1799> items, float requiredPower, class_2680 blockState) {
        if (!this.breakBlockAndStoreExtraItems(sink, this.level, this.pos)) {
            return;
        }
        for (class_1799 item : items) {
            int inserted = this.storeItemStack(sink, item);
            if (inserted >= item.method_7947()) continue;
            item.method_7934(inserted);
            Platform.spawnDrops((class_1937)this.level, this.pos, Collections.singletonList(item));
        }
        energySource.extractAEPower(requiredPower, Actionable.MODULATE, PowerMultiplier.CONFIG);
        AppEng.instance().sendToAllNearExcept(null, this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260(), 64.0, (class_1937)this.level, new BlockTransitionEffectPacket(this.pos, blockState, this.side, BlockTransitionEffectPacket.SoundMode.NONE));
    }

    private boolean storeEntityItem(PickupSink sink, class_1542 entityItem) {
        if (entityItem.method_5805()) {
            int inserted = this.storeItemStack(sink, entityItem.method_6983());
            return this.handleOverflow(entityItem, inserted);
        }
        return false;
    }

    private int storeItemStack(PickupSink sink, class_1799 item) {
        int amount;
        if (item.method_7960()) {
            return 0;
        }
        AEItemKey what = AEItemKey.of(item);
        int inserted = (int)sink.insert(what, amount = item.method_7947(), Actionable.MODULATE);
        this.isAccepting = inserted >= amount;
        return inserted;
    }

    private boolean handleOverflow(class_1542 entityItem, int inserted) {
        int entityItemCount = entityItem.method_6983().method_7947();
        if (inserted >= entityItemCount) {
            entityItem.method_31472();
            return true;
        }
        int newStackSize = entityItemCount - inserted;
        boolean changed = entityItemCount != newStackSize;
        entityItem.method_6983().method_7939(newStackSize);
        return changed;
    }

    private boolean canHandleBlock(class_3218 level, class_2338 pos, class_2680 state) {
        if (state.method_26215()) {
            return false;
        }
        if (ItemPickupStrategy.isBlockBlacklisted(state.method_26204())) {
            return false;
        }
        float hardness = state.method_26214((class_1922)level, pos);
        boolean ignoreAirAndFluids = state.method_26215() || state.method_51176();
        return !ignoreAirAndFluids && hardness >= 0.0f && level.method_8477(pos) && level.method_8505(Platform.getFakePlayer(level, this.ownerUuid), pos);
    }

    protected List<class_1799> obtainBlockDrops(class_3218 level, class_2338 pos) {
        class_1657 fakePlayer = Platform.getFakePlayer(level, this.ownerUuid);
        class_2680 state = level.method_8320(pos);
        class_2586 blockEntity = level.method_8321(pos);
        HarvestTool harvestTool = this.createHarvestTool(state);
        class_1799 harvestToolItem = harvestTool.item();
        if (!state.method_29291() && harvestTool.fallback()) {
            harvestToolItem = class_1799.field_8037;
        }
        List drops = class_2248.method_9609((class_2680)state, (class_3218)level, (class_2338)pos, (class_2586)blockEntity, (class_1297)fakePlayer, (class_1799)harvestToolItem);
        return drops.stream().filter(stack -> !stack.method_7960()).toList();
    }

    protected float calculateEnergyUsage(class_3218 level, class_2338 pos, List<class_1799> items) {
        boolean useEnergy = true;
        class_2680 state = level.method_8320(pos);
        float hardness = state.method_26214((class_1922)level, pos);
        float requiredEnergy = 1.0f + hardness;
        for (class_1799 is : items) {
            requiredEnergy += (float)is.method_7947();
        }
        if (this.enchantments != null) {
            int levelSum;
            Integer unbreakingLevel;
            float efficiencyFactor = 1.0f;
            Integer efficiencyLevel = this.enchantments.getOrDefault(class_1893.field_9131, 0);
            if (efficiencyLevel > 0) {
                efficiencyFactor = (float)((double)efficiencyFactor * Math.pow(0.85, efficiencyLevel.intValue()));
            }
            if ((unbreakingLevel = this.enchantments.getOrDefault(class_1893.field_9119, 0)) > 0) {
                int randomNumber = level.method_8409().method_43048(unbreakingLevel + 1);
                useEnergy = randomNumber == 0;
            }
            requiredEnergy *= (float)((levelSum = this.enchantments.values().stream().reduce(0, Integer::sum) - efficiencyLevel - unbreakingLevel) > 0 ? 8 * levelSum : 1) * efficiencyFactor;
        }
        return useEnergy ? requiredEnergy : 0.0f;
    }

    private boolean canStoreItemStacks(PickupSink sink, List<class_1799> itemStacks) {
        boolean canStore = itemStacks.isEmpty();
        for (class_1799 itemStack : itemStacks) {
            AEItemKey itemToTest = AEItemKey.of(itemStack);
            long inserted = sink.insert(itemToTest, itemStack.method_7947(), Actionable.SIMULATE);
            if (inserted <= 0L) continue;
            canStore = true;
        }
        this.isAccepting = canStore;
        return canStore;
    }

    private boolean breakBlockAndStoreExtraItems(PickupSink sink, class_3218 level, class_2338 pos) {
        if (!level.method_22352(pos, false)) {
            return false;
        }
        class_238 box = new class_238(pos).method_1014(0.2);
        for (class_1542 itemEntity : level.method_18467(class_1542.class, box)) {
            this.storeEntityItem(sink, itemEntity);
        }
        return true;
    }

    private HarvestTool createHarvestTool(class_2680 state) {
        class_1799 tool;
        boolean fallback = false;
        if (state.method_26164(class_3481.field_33715)) {
            tool = new class_1799((class_1935)class_1802.field_8377, 1);
        } else if (state.method_26164(class_3481.field_33713)) {
            tool = new class_1799((class_1935)class_1802.field_8556, 1);
        } else if (state.method_26164(class_3481.field_33716)) {
            tool = new class_1799((class_1935)class_1802.field_8250, 1);
        } else if (state.method_26164(class_3481.field_33714)) {
            tool = new class_1799((class_1935)class_1802.field_8527, 1);
        } else {
            tool = new class_1799((class_1935)class_1802.field_8377, 1);
            fallback = true;
        }
        if (this.enchantments != null) {
            class_1890.method_8214(this.enchantments, (class_1799)tool);
            fallback = false;
        }
        return new HarvestTool(tool, fallback);
    }

    public static boolean isBlockBlacklisted(class_2248 b) {
        return b.method_40142().method_40220(BLOCK_BLACKLIST);
    }

    public static boolean isItemBlacklisted(class_1792 i) {
        return i.method_40131().method_40220(ITEM_BLACKLIST);
    }

    record HarvestTool(class_1799 item, boolean fallback) {
    }
}

