/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.transform;

import appeng.recipes.transform.TransformCircumstance;
import appeng.recipes.transform.TransformRecipe;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_5819;

public final class TransformLogic {
    static Map<class_3611, Set<class_1792>> fluidCache = new IdentityHashMap<class_3611, Set<class_1792>>();
    static Set<class_1792> explosionCache = null;
    static Set<class_1792> anyFluidCache = null;

    public static boolean canTransformInFluid(class_1542 entity, class_3610 fluid) {
        return TransformLogic.getTransformableItems(entity.method_37908(), fluid.method_15772()).contains(entity.method_6983().method_7909());
    }

    public static boolean canTransformInAnyFluid(class_1542 entity) {
        return TransformLogic.getTransformableItemsAnyFluid(entity.method_37908()).contains(entity.method_6983().method_7909());
    }

    public static boolean canTransformInExplosion(class_1542 entity) {
        return TransformLogic.getTransformableItemsExplosion(entity.method_37908()).contains(entity.method_6983().method_7909());
    }

    public static boolean tryTransform(class_1542 entity, Predicate<TransformCircumstance> circumstancePredicate) {
        class_1937 level = entity.method_37908();
        class_238 region = new class_238(entity.method_23317() - 1.0, entity.method_23318() - 1.0, entity.method_23321() - 1.0, entity.method_23317() + 1.0, entity.method_23318() + 1.0, entity.method_23321() + 1.0);
        List<class_1542> itemEntities = level.method_8335(null, region).stream().filter(e -> e instanceof class_1542 && !e.method_31481()).map(e -> (class_1542)e).toList();
        for (TransformRecipe recipe : level.method_8433().method_17717(TransformRecipe.TYPE).values()) {
            if (!circumstancePredicate.test(recipe.circumstance) || recipe.ingredients.size() == 0) continue;
            ArrayList missingIngredients = Lists.newArrayList(recipe.ingredients);
            ReferenceOpenHashSet selectedEntities = new ReferenceOpenHashSet(missingIngredients.size());
            if (recipe.circumstance.isExplosion() ? missingIngredients.stream().noneMatch(i -> i.method_8093(entity.method_6983())) : !((class_1856)missingIngredients.get(0)).method_8093(entity.method_6983())) continue;
            block1: for (class_1542 itemEntity : itemEntities) {
                class_1799 other = itemEntity.method_6983();
                if (other.method_7960()) continue;
                Iterator it = missingIngredients.iterator();
                while (it.hasNext()) {
                    class_1856 ing = (class_1856)it.next();
                    if (!ing.method_8093(other)) continue;
                    selectedEntities.add(itemEntity);
                    it.remove();
                    continue block1;
                }
            }
            if (!missingIngredients.isEmpty()) continue;
            class_1277 recipeContainer = new class_1277(selectedEntities.size());
            int i2 = 0;
            for (class_1542 e2 : selectedEntities) {
                recipeContainer.method_5447(i2++, e2.method_6983().method_7971(1));
                if (e2.method_6983().method_7947() > 0) continue;
                e2.method_31472();
            }
            class_5819 random = level.method_8409();
            double x = Math.floor(entity.method_23317()) + 0.25 + random.method_43058() * 0.5;
            double y = Math.floor(entity.method_23318()) + 0.25 + random.method_43058() * 0.5;
            double z = Math.floor(entity.method_23321()) + 0.25 + random.method_43058() * 0.5;
            double xSpeed = random.method_43058() * 0.25 - 0.125;
            double ySpeed = random.method_43058() * 0.25 - 0.125;
            double zSpeed = random.method_43058() * 0.25 - 0.125;
            class_1542 newEntity = new class_1542(level, x, y, z, recipe.method_8116((class_1263)recipeContainer, level.method_30349()));
            newEntity.method_18800(xSpeed, ySpeed, zSpeed);
            level.method_8649((class_1297)newEntity);
            return true;
        }
        return false;
    }

    private static void clearCache() {
        fluidCache.clear();
        explosionCache = null;
        anyFluidCache = null;
    }

    private static Set<class_1792> getTransformableItems(class_1937 level, class_3611 fluid) {
        return fluidCache.computeIfAbsent(fluid, f -> {
            Set ret = Collections.newSetFromMap(new IdentityHashMap());
            for (TransformRecipe recipe : level.method_8433().method_30027(TransformRecipe.TYPE)) {
                Iterator iterator;
                if (!recipe.circumstance.isFluid(fluid) || !(iterator = recipe.ingredients.iterator()).hasNext()) continue;
                class_1856 ingredient = (class_1856)iterator.next();
                for (class_1799 stack : ingredient.method_8105()) {
                    ret.add(stack.method_7909());
                }
            }
            return ret;
        });
    }

    private static Set<class_1792> getTransformableItemsAnyFluid(class_1937 level) {
        Set<Object> ret = anyFluidCache;
        if (ret == null) {
            ret = Collections.newSetFromMap(new IdentityHashMap());
            for (TransformRecipe recipe : level.method_8433().method_30027(TransformRecipe.TYPE)) {
                Iterator iterator;
                if (!recipe.circumstance.isFluid() || !(iterator = recipe.ingredients.iterator()).hasNext()) continue;
                class_1856 ingredient = (class_1856)iterator.next();
                for (class_1799 stack : ingredient.method_8105()) {
                    ret.add(stack.method_7909());
                }
            }
            anyFluidCache = ret;
        }
        return ret;
    }

    private static Set<class_1792> getTransformableItemsExplosion(class_1937 level) {
        Set<Object> ret = explosionCache;
        if (ret == null) {
            ret = Collections.newSetFromMap(new IdentityHashMap());
            for (TransformRecipe recipe : level.method_8433().method_30027(TransformRecipe.TYPE)) {
                if (!recipe.circumstance.isExplosion()) continue;
                for (class_1856 ingredient : recipe.ingredients) {
                    for (class_1799 stack : ingredient.method_8105()) {
                        ret.add(stack.method_7909());
                    }
                }
            }
            explosionCache = ret;
        }
        return ret;
    }

    private TransformLogic() {
    }

    static {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> TransformLogic.clearCache());
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, resourceManager, success) -> {
            if (success) {
                TransformLogic.clearCache();
            }
        });
        CommonLifecycleEvents.TAGS_LOADED.register((registries, client) -> {
            if (client) {
                TransformLogic.clearCache();
            }
        });
    }
}

