/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.textile.provider;

import java.util.HashSet;
import java.util.Set;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.data.FluidData;
import mcp.mobius.waila.api.fabric.FabricFluidData;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public enum FluidStorageProvider implements IDataProvider<class_2586>
{
    INSTANCE;

    @Nullable
    private @Nullable BlockApiCache<Storage<FluidVariant>, @Nullable class_2350> cache;

    @Override
    public void appendData(IDataWriter data, IServerAccessor<class_2586> accessor, IPluginConfig config) {
        data.add(FluidData.class, res -> {
            Storage storage;
            if (this.cache == null || this.cache.getBlockEntity() != accessor.getTarget()) {
                this.cache = BlockApiCache.create((BlockApiLookup)FluidStorage.SIDED, (class_3218)((class_3218)accessor.getWorld()), (class_2338)((class_2586)accessor.getTarget()).method_11016());
            }
            if ((storage = (Storage)this.cache.find(((class_2586)accessor.getTarget()).method_11010(), null)) instanceof SingleSlotStorage) {
                SingleSlotStorage single = (SingleSlotStorage)storage;
                FluidData.PlatformDependant<FluidVariant> fluidData = FabricFluidData.of();
                this.addFluid(fluidData, (StorageView<FluidVariant>)single);
                res.add(fluidData);
            } else if (storage instanceof SlottedStorage) {
                SlottedStorage slotted = (SlottedStorage)storage;
                int size = slotted.getSlotCount();
                FluidData.PlatformDependant<FluidVariant> fluidData = FabricFluidData.of(size);
                for (int i = 0; i < size; ++i) {
                    SingleSlotStorage slot = slotted.getSlot(i);
                    this.addFluid(fluidData, (StorageView<FluidVariant>)slot);
                }
                res.add(fluidData);
            } else if (storage != null) {
                HashSet<StorageView<FluidVariant>> uniqueViews = new HashSet<StorageView<FluidVariant>>();
                FluidData.PlatformDependant<FluidVariant> fluidData = FabricFluidData.of();
                for (StorageView view : storage) {
                    this.addFluid(uniqueViews, fluidData, (StorageView<FluidVariant>)view);
                }
                res.add(fluidData);
            }
        });
    }

    private void addFluid(Set<StorageView<FluidVariant>> uniqueViews, FluidData.PlatformDependant<FluidVariant> fluidData, StorageView<FluidVariant> view) {
        StorageView uniqueView = view.getUnderlyingView();
        if (uniqueViews.add((StorageView<FluidVariant>)uniqueView)) {
            this.addFluid(fluidData, view);
        }
    }

    private void addFluid(FluidData.PlatformDependant<FluidVariant> fluidData, StorageView<FluidVariant> view) {
        if (view.isResourceBlank()) {
            return;
        }
        fluidData.add((FluidVariant)view.getResource(), view.getAmount(), view.getCapacity());
    }
}

