/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.util;

import com.tiviacz.travelersbackpack.inventory.handler.IItemHandlerModifiable;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public class InventoryHelper {
    public static class_1799 removeItem(IItemHandlerModifiable handler, int slot, int amount) {
        if (slot >= 0 && slot < handler.getSlots() && !handler.getStackInSlot(slot).method_7960() && amount > 0) {
            class_1799 currentStack = handler.getStackInSlot(slot).method_7972();
            class_1799 stackAtPointer = currentStack.method_7972();
            currentStack.method_7971(amount);
            handler.setStackInSlot(slot, currentStack);
            return stackAtPointer;
        }
        return class_1799.field_8037;
    }

    public static class_1799 removeItemShiftClick(IItemHandlerModifiable handler, int slot, int amount) {
        if (slot >= 0 && slot < handler.getSlots() && !handler.getStackInSlot(slot).method_7960() && amount > 0) {
            class_1799 currentStack = handler.getStackInSlot(slot);
            currentStack.method_7971(amount);
            handler.setStackInSlot(slot, currentStack);
            return handler.getStackInSlot(slot);
        }
        return class_1799.field_8037;
    }

    public static class_1799 takeItem(ItemStackHandler handler, int slot) {
        return slot >= 0 && slot < handler.getSlots() ? handler.insertItem(slot, class_1799.field_8037, false) : class_1799.field_8037;
    }

    public static boolean isEmpty(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    public static void iteratePlayerInv(class_1661 playerInv, BiConsumer<Integer, class_1799> consumer) {
        for (int i = 0; i < playerInv.method_5439(); ++i) {
            class_1799 stack = playerInv.method_5438(i);
            consumer.accept(i, stack);
        }
    }

    public static void iterateHandler(ItemStackHandler handler, BiConsumer<Integer, class_1799> consumer) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            class_1799 stack = handler.getStackInSlot(i);
            consumer.accept(i, stack);
        }
    }

    public static boolean iterate(ItemStackHandler handler, BiFunction<Integer, class_1799, Boolean> function) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            boolean matches = function.apply(i, handler.getStackInSlot(i).method_7972());
            if (!matches) continue;
            return true;
        }
        return false;
    }

    public static class_1799 addItemStackToHandler(ItemStackHandler handler, class_1799 stack, boolean simulate) {
        return InventoryHelper.insertItemStacked(handler, stack, simulate);
    }

    public static class_1799 extractFromBackpack(ItemStackHandler handler, class_1799 stack, int amount, boolean simulate) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!class_1799.method_31577((class_1799)stack, (class_1799)handler.getStackInSlot(i))) continue;
            return handler.extractItem(i, amount, simulate);
        }
        return class_1799.field_8037;
    }

    @NotNull
    public static class_1799 insertItemStacked(ItemStackHandler inventory, @NotNull class_1799 stack, boolean simulate) {
        if (inventory != null && !stack.method_7960()) {
            class_1799 slot;
            int i;
            if (!stack.method_7946()) {
                return InventoryHelper.insertItem(inventory, stack, simulate);
            }
            int sizeInventory = inventory.getSlots();
            for (i = 0; !(i >= sizeInventory || InventoryHelper.canItemStacksStackRelaxed(slot = inventory.getStackInSlot(i), stack) && (stack = inventory.insertItem(i, stack, simulate)).method_7960()); ++i) {
            }
            if (!stack.method_7960()) {
                for (i = 0; !(i >= sizeInventory || inventory.getStackInSlot(i).method_7960() && (stack = inventory.insertItem(i, stack, simulate)).method_7960()); ++i) {
                }
            }
            return stack;
        }
        return stack;
    }

    public static boolean canItemStacksStackRelaxed(@NotNull class_1799 a, @NotNull class_1799 b) {
        if (!a.method_7960() && !b.method_7960() && a.method_7909() == b.method_7909()) {
            if (!a.method_7946()) {
                return false;
            }
            if (a.method_7985() != b.method_7985()) {
                return false;
            }
            return !a.method_7985() || a.method_7969().equals((Object)b.method_7969());
        }
        return false;
    }

    @NotNull
    public static class_1799 insertItem(ItemStackHandler dest, @NotNull class_1799 stack, boolean simulate) {
        if (dest != null && !stack.method_7960()) {
            for (int i = 0; i < dest.getSlots(); ++i) {
                if (!(stack = dest.insertItem(i, stack, simulate)).method_7960()) continue;
                return class_1799.field_8037;
            }
            return stack;
        }
        return stack;
    }

    public static boolean canItemStacksStack(@NotNull class_1799 a, @NotNull class_1799 b) {
        if (!a.method_7960() && class_1799.method_7984((class_1799)a, (class_1799)b) && a.method_7985() == b.method_7985()) {
            return !a.method_7985() || a.method_7969().equals((Object)b.method_7969());
        }
        return false;
    }

    @NotNull
    public static class_1799 copyStackWithSize(@NotNull class_1799 itemStack, int size) {
        if (size == 0) {
            return class_1799.field_8037;
        }
        class_1799 copy = itemStack.method_7972();
        copy.method_7939(size);
        return copy;
    }
}

