/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.List;
import java.util.stream.Collectors;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.blay09.mods.waystones.core.WaystoneTypes;
import net.blay09.mods.waystones.network.message.KnownWaystonesMessage;
import net.blay09.mods.waystones.network.message.PlayerWaystoneCooldownsMessage;
import net.blay09.mods.waystones.network.message.UpdateWaystoneMessage;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class WaystoneSyncManager {
    public static void sendWaystoneUpdateToAll(@Nullable MinecraftServer server, IWaystone waystone) {
        if (server == null) {
            return;
        }
        List players = server.method_3760().method_14571();
        for (class_3222 player : players) {
            WaystoneSyncManager.sendWaystoneUpdate((class_1657)player, waystone);
            WaystoneSyncManager.sendActivatedWaystones((class_1657)player);
        }
    }

    public static void sendActivatedWaystones(class_1657 player) {
        List<IWaystone> waystones = PlayerWaystoneManager.getWaystones(player);
        Balm.getNetworking().sendTo(player, (Object)new KnownWaystonesMessage(WaystoneTypes.WAYSTONE, waystones));
    }

    public static void sendWarpPlates(class_3222 player) {
        List<IWaystone> warpPlates = WaystoneManager.get(player.field_13995).getWaystonesByType(WaystoneTypes.WARP_PLATE).collect(Collectors.toList());
        Balm.getNetworking().sendTo((class_1657)player, (Object)new KnownWaystonesMessage(WaystoneTypes.WARP_PLATE, warpPlates));
    }

    public static void sendWaystoneUpdate(class_1657 player, IWaystone waystone) {
        if (!waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE) || PlayerWaystoneManager.isWaystoneActivated(player, waystone)) {
            Balm.getNetworking().sendTo(player, (Object)new UpdateWaystoneMessage(waystone));
        }
    }

    public static void sendWaystoneCooldowns(class_1657 player) {
        long inventoryButtonCooldownUntil = PlayerWaystoneManager.getInventoryButtonCooldownUntil(player);
        long warpStoneCooldownUntil = PlayerWaystoneManager.getWarpStoneCooldownUntil(player);
        Balm.getNetworking().sendTo(player, (Object)new PlayerWaystoneCooldownsMessage(inventoryButtonCooldownUntil, warpStoneCooldownUntil));
    }
}

