/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannons.big_cannons.breeches.quickfiring_breech;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBehavior;
import rbasamoyai.createbigcannons.cannons.big_cannons.IBigCannonBlockEntity;
import rbasamoyai.createbigcannons.config.CBCConfigs;

public class QuickfiringBreechBlockEntity
extends SmartBlockEntity
implements IBigCannonBlockEntity {
    private BigCannonBehavior cannonBehavior;
    private int openProgress;
    private boolean inPonder;
    private int openDirection;
    private int loadingCooldown;

    public QuickfiringBreechBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.cannonBehavior = new BigCannonBehavior(this, this::canLoadBlock);
        behaviours.add(this.cannonBehavior);
    }

    @Override
    public boolean canLoadBlock(class_3499.class_3501 blockInfo) {
        return false;
    }

    @Override
    public BigCannonBehavior cannonBehavior() {
        return this.cannonBehavior;
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.method_10556("InPonder", this.inPonder);
        tag.method_10569("OpenProgress", this.openProgress);
        tag.method_10569("OpenDirection", this.openDirection);
        tag.method_10569("LoadingCooldown", this.loadingCooldown);
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.inPonder = tag.method_10577("InPonder");
        this.openProgress = tag.method_10550("OpenProgress");
        this.openDirection = class_3532.method_15340((int)tag.method_10550("OpenDirection"), (int)-1, (int)1);
        this.loadingCooldown = Math.max(0, tag.method_10550("LoadingCooldown"));
    }

    public void tick() {
        super.tick();
        if (!this.inPonder) {
            if (this.openProgress != 0) {
                this.openProgress = 0;
            }
            if (this.openDirection != 0) {
                this.openDirection = 0;
            }
        }
    }

    public void tickAnimation() {
        if (this.openDirection != 0 && !QuickfiringBreechBlockEntity.isInstantOpen()) {
            this.openProgress = class_3532.method_15340((int)(this.openProgress + this.openDirection), (int)0, (int)Math.max(QuickfiringBreechBlockEntity.getOpeningTime(), 1));
            if (!this.onInteractionCooldown()) {
                this.openDirection = 0;
            }
        }
        if (this.loadingCooldown > 0) {
            --this.loadingCooldown;
        }
    }

    public boolean isOpen() {
        return QuickfiringBreechBlockEntity.isInstantOpen() ? this.openProgress > 0 : this.openProgress >= QuickfiringBreechBlockEntity.getOpeningTime();
    }

    public int getOpenDirection() {
        return this.openDirection;
    }

    public void toggleOpening() {
        if (QuickfiringBreechBlockEntity.isInstantOpen()) {
            this.openProgress = this.openProgress > 0 ? 0 : 1;
            return;
        }
        if (!this.onInteractionCooldown()) {
            this.openDirection = this.isOpen() ? -1 : 1;
        }
    }

    public float getOpenProgress(float partialTicks) {
        if (QuickfiringBreechBlockEntity.isInstantOpen()) {
            return class_3532.method_15363((float)this.openProgress, (float)0.0f, (float)1.0f);
        }
        return class_3532.method_15363((float)(((float)this.openProgress + (float)this.openDirection * partialTicks) / (float)QuickfiringBreechBlockEntity.getOpeningTime()), (float)0.0f, (float)1.0f);
    }

    public int getOpenProgress() {
        return this.openProgress;
    }

    public boolean onInteractionCooldown() {
        return 0 < this.openProgress && this.openProgress < QuickfiringBreechBlockEntity.getOpeningTime();
    }

    public boolean canBeAutomaticallyLoaded() {
        return this.loadingCooldown <= 0 && this.openProgress == 0;
    }

    public void setLoadingCooldown(int value) {
        this.loadingCooldown = value;
    }

    public static int getOpeningTime() {
        return (Integer)CBCConfigs.SERVER.cannons.quickfiringBreechOpeningCooldown.get();
    }

    public static boolean isInstantOpen() {
        return QuickfiringBreechBlockEntity.getOpeningTime() <= 0;
    }
}

