/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.foundry;

import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinOperatingBlockEntity;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1860;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import rbasamoyai.createbigcannons.index.CBCRecipeTypes;

public class BasinFoundryBlockEntity
extends BasinOperatingBlockEntity {
    public int meltingTime;
    public int recipeCooldown;
    public boolean running;
    private static final Object BASIN_MELTING_RECIPE_KEY = new Object();

    public BasinFoundryBlockEntity(class_2591<? extends BasinFoundryBlockEntity> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
    }

    protected void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.method_10569("MeltingTime", this.meltingTime);
        compound.method_10556("Running", this.running);
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.meltingTime = compound.method_10550("MeltingTime");
        this.running = compound.method_10577("Running");
    }

    protected boolean isRunning() {
        return this.running;
    }

    protected void onBasinRemoved() {
        if (!this.running) {
            return;
        }
        this.meltingTime = 0;
        this.currentRecipe = null;
        this.running = false;
    }

    public void tick() {
        super.tick();
        if (!(this.method_10997().field_9236 || this.currentRecipe != null && this.meltingTime != -1)) {
            --this.recipeCooldown;
            if (this.recipeCooldown <= 0) {
                this.running = false;
                this.meltingTime = -1;
                this.basinChecker.scheduleUpdate();
                this.recipeCooldown = 20;
            }
        } else {
            this.recipeCooldown = 0;
        }
        if (this.running && this.method_10997() != null) {
            if (this.method_10997().field_9236 && this.meltingTime > 0) {
                this.renderParticles();
            }
            if (!this.method_10997().field_9236 && this.meltingTime <= 0) {
                this.meltingTime = -1;
                this.applyBasinRecipe();
                this.sendData();
            }
            if (this.meltingTime > 0) {
                --this.meltingTime;
            }
        }
    }

    private void renderParticles() {
        float angle = this.method_10997().field_9229.method_43057() * 360.0f;
        class_243 offset = new class_243(0.0, 0.0, 0.25);
        offset = VecHelper.rotate((class_243)offset, (double)angle, (class_2350.class_2351)class_2350.class_2351.field_11052);
        class_243 target = VecHelper.rotate((class_243)offset, (double)-25.0, (class_2350.class_2351)class_2350.class_2351.field_11052).method_1031(0.0, 0.5, 0.0);
        class_243 center = offset.method_1019(class_243.method_24955((class_2382)this.field_11867));
        target = VecHelper.offsetRandomly((class_243)target.method_1020(offset), (class_5819)this.method_10997().field_9229, (float)0.0078125f);
        this.method_10997().method_8406((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10164.method_9564()), center.field_1352, center.field_1351 + 0.3, center.field_1350, target.field_1352, target.field_1351, target.field_1350);
    }

    protected boolean updateBasin() {
        if (this.running) {
            return true;
        }
        if (this.method_10997() == null || this.method_10997().field_9236) {
            return true;
        }
        if (!this.getBasin().filter(BasinBlockEntity::canContinueProcessing).isPresent()) {
            return true;
        }
        List recipes = this.getMatchingRecipes();
        if (recipes.isEmpty()) {
            return true;
        }
        this.currentRecipe = (class_1860)recipes.get(0);
        this.startProcessingBasin();
        this.sendData();
        return true;
    }

    public void startProcessingBasin() {
        int n;
        if (this.running && this.meltingTime > 0) {
            return;
        }
        super.startProcessingBasin();
        this.running = true;
        class_1860 class_18602 = this.currentRecipe;
        if (class_18602 instanceof ProcessingRecipe) {
            ProcessingRecipe processed = (ProcessingRecipe)class_18602;
            n = processed.getProcessingDuration();
        } else {
            n = 20;
        }
        this.meltingTime = n;
    }

    protected <C extends class_1263> boolean matchStaticFilters(class_1860<C> recipe) {
        return recipe.method_17716() == CBCRecipeTypes.MELTING.getType();
    }

    protected Object getRecipeCacheKey() {
        return BASIN_MELTING_RECIPE_KEY;
    }

    protected Optional<BasinBlockEntity> getBasin() {
        Optional<BasinBlockEntity> optional;
        class_2586 class_25862;
        if (this.method_10997() != null && (class_25862 = this.method_10997().method_8321(this.field_11867.method_10074())) instanceof BasinBlockEntity) {
            BasinBlockEntity basin = (BasinBlockEntity)class_25862;
            optional = Optional.of(basin);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }
}

