/*
 * Decompiled with CFR 0.152.
 */
package net.im_maker.wallpapers.config.t;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class WallpapersClientConfigs {
    private static final File CONFIG_FILE = new File("config/wallpapers-client.json");
    private boolean tooltips = true;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static WallpapersClientConfigs INSTANCE;

    private WallpapersClientConfigs() {
    }

    public static WallpapersClientConfigs getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WallpapersClientConfigs();
            INSTANCE.load();
        }
        return INSTANCE;
    }

    public void load() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                WallpapersClientConfigs config = (WallpapersClientConfigs)GSON.fromJson((Reader)reader, WallpapersClientConfigs.class);
                this.tooltips = config.tooltips;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.save();
        }
    }

    public void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean getTooltips() {
        return this.tooltips;
    }

    public void setTooltips(boolean tooltips) {
        this.tooltips = tooltips;
    }
}

