/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.listeners;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnLootGenerated;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.item.LootHelper;
import com.majruszlibrary.level.BlockHelper;
import com.majruszlibrary.math.Range;
import com.majruszsaccessories.MajruszsAccessories;
import com.majruszsaccessories.config.Config;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2621;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

@AutoInstance
public class BoosterDropper {
    private class_2960 lootTable = MajruszsAccessories.HELPER.getLocation("gameplay/nether_accessories");
    private float chestChance = 0.1f;
    private float mobChance = 0.005f;

    public BoosterDropper() {
        OnLootGenerated.listen(this::spawnBoosterInChest).addCondition(Condition.isLogicalServer()).addCondition(Condition.hasLevel()).addCondition(Condition.chance(() -> Float.valueOf(this.chestChance))).addCondition(Condition.predicate(data -> data.origin != null)).addCondition(Condition.predicate(data -> BlockHelper.getEntity((class_1937)data.getLevel(), (class_243)data.origin) instanceof class_2621)).addCondition(Condition.predicate(data -> data.entity instanceof class_3222)).addCondition(Condition.predicate(data -> EntityHelper.isIn((class_1297)data.entity, (class_5321)class_1937.field_25180)));
        OnLootGenerated.listen(this::dropBoosterFromMonster).addCondition(Condition.isLogicalServer()).addCondition(Condition.hasLevel()).addCondition(Condition.chance(() -> Float.valueOf(this.mobChance))).addCondition(Condition.predicate(data -> data.entity != null)).addCondition(Condition.predicate(data -> data.killer != null)).addCondition(Condition.predicate(data -> data.lastDamagePlayer != null)).addCondition(Condition.predicate(data -> EntityHelper.isIn((class_1297)data.killer, (class_5321)class_1937.field_25180)));
        Serializables.get(Config.Boosters.class).define("loot_table", Reader.location(), s -> this.lootTable, (s, v) -> {
            this.lootTable = v;
        }).define("nether_chest_chance", Reader.number(), s -> Float.valueOf(this.chestChance), (s, v) -> {
            this.chestChance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        }).define("nether_mob_chance", Reader.number(), s -> Float.valueOf(this.mobChance), (s, v) -> {
            this.mobChance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        });
    }

    private void spawnBoosterInChest(OnLootGenerated data) {
        this.addBooster(data, data.entity);
    }

    private void dropBoosterFromMonster(OnLootGenerated data) {
        this.addBooster(data, data.killer);
    }

    private void addBooster(OnLootGenerated data, class_1297 entity) {
        LootHelper.getLootTable((class_2960)this.lootTable).method_51878(LootHelper.toGiftParams((class_1297)entity)).forEach(arg_0 -> ((ObjectArrayList)data.generatedLoot).add(arg_0));
    }
}

