/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.advancement.predicate;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class CameraPredicate {
    public static final CameraPredicate ANY = new CameraPredicate(class_2073.field_9640, class_2096.class_2099.field_9705, class_2096.class_2100.field_9708, class_2073.field_9640, class_2073.field_9640, class_2073.field_9640, class_2073.field_9640);
    private final class_2073 camera;
    private final class_2096.class_2099 shutterSpeedMS;
    private final class_2096.class_2100 focalLength;
    private final class_2073 film;
    private final class_2073 flash;
    private final class_2073 lens;
    private final class_2073 filter;

    public CameraPredicate(class_2073 camera, class_2096.class_2099 shutterSpeedMS, class_2096.class_2100 focalLength, class_2073 film, class_2073 flash, class_2073 lens, class_2073 filter) {
        this.camera = camera;
        this.shutterSpeedMS = shutterSpeedMS;
        this.focalLength = focalLength;
        this.film = film;
        this.flash = flash;
        this.lens = lens;
        this.filter = filter;
    }

    public boolean matches(ItemAndStack<CameraItem> camera) {
        if (this.equals(ANY)) {
            return true;
        }
        class_1799 stack = camera.getStack();
        CameraItem item = camera.getItem();
        return this.camera.method_8970(stack) && this.shutterSpeedMS.method_9047((double)item.getShutterSpeed(stack).getMilliseconds()) && this.focalLength.method_9054(class_3532.method_15386((float)item.getFocalLength(stack))) && this.film.method_8970(item.getAttachment(stack, CameraItem.FILM_ATTACHMENT).orElse(class_1799.field_8037)) && this.flash.method_8970(item.getAttachment(stack, CameraItem.FLASH_ATTACHMENT).orElse(class_1799.field_8037)) && this.lens.method_8970(item.getAttachment(stack, CameraItem.LENS_ATTACHMENT).orElse(class_1799.field_8037)) && this.filter.method_8970(item.getAttachment(stack, CameraItem.FILTER_ATTACHMENT).orElse(class_1799.field_8037));
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject json = new JsonObject();
        json.add("camera", this.camera.method_8971());
        json.add("shutter_speed_ms", this.shutterSpeedMS.method_9036());
        json.add("focal_length", this.focalLength.method_9036());
        json.add("film", this.film.method_8971());
        json.add("flash", this.flash.method_8971());
        json.add("lens", this.lens.method_8971());
        json.add("filter", this.filter.method_8971());
        return json;
    }

    public static CameraPredicate fromJson(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return ANY;
        }
        JsonObject jsonObj = class_3518.method_15295((JsonElement)json, (String)"camera");
        return new CameraPredicate(class_2073.method_8969((JsonElement)jsonObj.getAsJsonObject("camera")), class_2096.class_2099.method_9051((JsonElement)jsonObj.getAsJsonObject("shutter_speed_ms")), class_2096.class_2100.method_9056((JsonElement)jsonObj.getAsJsonObject("focal_length")), class_2073.method_8969((JsonElement)jsonObj.getAsJsonObject("film")), class_2073.method_8969((JsonElement)jsonObj.getAsJsonObject("flash")), class_2073.method_8969((JsonElement)jsonObj.getAsJsonObject("lens")), class_2073.method_8969((JsonElement)jsonObj.getAsJsonObject("filter")));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CameraPredicate that = (CameraPredicate)o;
        return Objects.equals(this.camera, that.camera) && Objects.equals(this.shutterSpeedMS, that.shutterSpeedMS) && Objects.equals(this.focalLength, that.focalLength) && Objects.equals(this.film, that.film) && Objects.equals(this.flash, that.flash) && Objects.equals(this.lens, that.lens) && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(this.camera, this.shutterSpeedMS, this.focalLength, this.film, this.flash, this.lens, this.filter);
    }
}

