/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.capture;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.capture.component.ICaptureComponent;
import io.github.mortuusars.exposure.camera.capture.converter.IImageToMapColorsConverter;
import io.github.mortuusars.exposure.camera.capture.converter.SimpleColorConverter;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1011;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Capture {
    protected FilmType type = FilmType.COLOR;
    protected int size = 320;
    protected float cropFactor = 1.142857f;
    protected float brightnessStops = 0.0f;
    protected boolean asyncCapturing = false;
    protected boolean asyncProcessing = true;
    protected ArrayList<ICaptureComponent> components = new ArrayList();
    protected IImageToMapColorsConverter converter = new SimpleColorConverter();
    protected Runnable onImageCaptured = () -> {};
    protected Runnable onCapturingFailed = () -> {};
    protected int ticksDelay = -1;
    protected int framesDelay = -1;
    protected long captureTick;
    protected long currentTick;
    protected boolean isCapturing = false;
    protected boolean done = false;

    @Nullable
    public abstract class_1011 captureImage();

    public boolean isDone() {
        return this.done;
    }

    public int getTicksDelay() {
        return (int)(this.captureTick - Objects.requireNonNull(class_310.method_1551().field_1687).method_8510());
    }

    public int getFramesDelay() {
        return this.framesDelay;
    }

    public FilmType getFilmType() {
        return this.type;
    }

    public Capture setFilmType(FilmType type) {
        this.type = type;
        return this;
    }

    public int getSize() {
        return this.size;
    }

    public Capture setSize(int size) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (String)"'size [{}] is not valid' should be larger than 0.", (int)size);
        this.size = size;
        return this;
    }

    public float getCropFactor() {
        return this.cropFactor;
    }

    public Capture cropFactor(float cropFactor) {
        Preconditions.checkArgument((cropFactor != 0.0f ? 1 : 0) != 0, (String)"'cropFactor [{}] is not valid' should be larger than 0.", (Object)Float.valueOf(cropFactor));
        this.cropFactor = cropFactor;
        return this;
    }

    public float getBrightnessStops() {
        return this.brightnessStops;
    }

    public Capture setBrightnessStops(float brightnessStops) {
        this.brightnessStops = brightnessStops;
        return this;
    }

    public Capture setAsyncCapturing(boolean asyncCapturing) {
        this.asyncCapturing = asyncCapturing;
        return this;
    }

    public Capture setAsyncProcessing(boolean asyncProcessing) {
        this.asyncProcessing = asyncProcessing;
        return this;
    }

    public Capture addComponent(ICaptureComponent component) {
        this.components.add(component);
        return this;
    }

    public Capture addComponents(ICaptureComponent ... components) {
        this.components.addAll(Arrays.asList(components));
        return this;
    }

    public Capture setComponents(ICaptureComponent ... components) {
        this.components = Arrays.stream(components).collect(Collectors.toCollection(ArrayList::new));
        return this;
    }

    public Capture setComponents(Collection<ICaptureComponent> components) {
        this.components = new ArrayList<ICaptureComponent>(components);
        return this;
    }

    public Capture setConverter(IImageToMapColorsConverter converter) {
        this.converter = converter;
        return this;
    }

    public Capture onImageCaptured(Runnable runnable) {
        this.onImageCaptured = runnable;
        return this;
    }

    public Capture onCapturingFailed(Runnable runnable) {
        this.onCapturingFailed = runnable;
        return this;
    }

    public void initialize() {
        for (ICaptureComponent modifier : this.components) {
            this.ticksDelay = Math.max(this.ticksDelay, modifier.getTicksDelay(this));
            this.framesDelay = Math.max(this.framesDelay, modifier.getFramesDelay(this));
        }
        for (ICaptureComponent modifier : this.components) {
            modifier.initialize(this);
        }
        this.currentTick = Objects.requireNonNull(class_310.method_1551().field_1687).method_8510();
        this.captureTick = this.currentTick + (long)this.ticksDelay;
        if (this.currentTick == this.captureTick && this.framesDelay <= 0) {
            for (ICaptureComponent modifier : this.components) {
                modifier.onDelayTick(this, 0);
                modifier.onDelayFrame(this, 0);
            }
        }
    }

    public synchronized void tick() {
        if (this.delayTick() || this.isCapturing) {
            return;
        }
        this.isCapturing = true;
        if (this.asyncCapturing) {
            new Thread(() -> {
                @Nullable class_1011 image = this.captureImage();
                this.onImageCaptured(image);
            }).start();
        } else {
            @Nullable class_1011 image = this.captureImage();
            this.onImageCaptured(image);
        }
    }

    protected boolean delayTick() {
        long lastTick = this.currentTick;
        this.currentTick = Objects.requireNonNull(class_310.method_1551().field_1687).method_8510();
        if (this.ticksDelay > 0) {
            if (lastTick < this.currentTick) {
                --this.ticksDelay;
                for (ICaptureComponent modifier : this.components) {
                    modifier.onDelayTick(this, this.ticksDelay);
                }
                if (this.ticksDelay == 0 && this.framesDelay == 0) {
                    for (ICaptureComponent modifier : this.components) {
                        modifier.onDelayFrame(this, 0);
                    }
                }
            }
            return true;
        }
        if (this.framesDelay > 0) {
            --this.framesDelay;
            for (ICaptureComponent modifier : this.components) {
                modifier.onDelayFrame(this, this.framesDelay);
            }
            return true;
        }
        return false;
    }

    protected void onImageCaptured(@Nullable class_1011 image) {
        if (image == null) {
            this.done = true;
            this.isCapturing = false;
            this.onCapturingFailed.run();
            return;
        }
        this.onImageCaptured.run();
        if (this.asyncCapturing) {
            class_310.method_1551().execute(() -> {
                for (ICaptureComponent modifier : this.components) {
                    modifier.imageTaken(this, image);
                }
            });
        } else {
            for (ICaptureComponent modifier : this.components) {
                modifier.imageTaken(this, image);
            }
        }
        if (this.asyncProcessing && !this.asyncCapturing) {
            new Thread(() -> this.processImage(image)).start();
        } else {
            this.processImage(image);
        }
        this.done = true;
        this.isCapturing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void processImage(@NotNull class_1011 image) {
        block28: {
            try {
                processedImage = this.scaleCropAndProcess(image);
                try {
                    if (processedImage == null) {
                        return;
                    }
                    modifiedImage = processedImage;
                    for (Object component : this.components) {
                        modifiedImage = component.modifyImage(this, modifiedImage);
                    }
                    pixels = this.converter.convert(this, modifiedImage);
                    for (ICaptureComponent component : this.components) {
                        component.teardown(this);
                    }
                    propertiesTag = new class_2487();
                    this.addSavedDataProperties(propertiesTag);
                    for (ICaptureComponent component : this.components) {
                        component.save(pixels, modifiedImage.method_4307(), modifiedImage.method_4323(), propertiesTag);
                    }
                }
                finally {
                    if (processedImage != null) {
                        processedImage.close();
                    }
                }
                ** try [egrp 6[TRYBLOCK] [4 : 282->322)] { 
            }
            catch (Exception e) {
                Exposure.LOGGER.error(e.toString());
                break block28;
            }
            finally {
                try {
                    for (ICaptureComponent component : this.components) {
                        component.end(this);
                    }
                }
                catch (Exception e) {
                    Exposure.LOGGER.error(e.toString());
                }
                this.isCapturing = false;
            }
lbl-1000:
            // 2 sources

            {
                for (ICaptureComponent component : this.components) {
                    component.end(this);
                }
            }
lbl31:
            // 1 sources

            catch (Exception e) {
                Exposure.LOGGER.error(e.toString());
            }
            this.isCapturing = false;
        }
    }

    protected void addSavedDataProperties(class_2487 tag) {
        tag.method_10582("Type", this.getFilmType().method_15434());
    }

    @Nullable
    protected class_1011 scaleCropAndProcess(@NotNull class_1011 sourceImage) {
        class_1011 class_10112;
        block8: {
            int sWidth = sourceImage.method_4307();
            int sHeight = sourceImage.method_4323();
            int sourceSize = Math.min(sWidth, sHeight);
            float crop = (float)sourceSize - (float)sourceSize / this.getCropFactor();
            sourceSize -= (int)crop;
            int sourceXStart = sWidth > sHeight ? (sWidth - sHeight) / 2 : 0;
            int sourceYStart = sHeight > sWidth ? (sHeight - sWidth) / 2 : 0;
            sourceXStart += (int)(crop / 2.0f);
            sourceYStart += (int)(crop / 2.0f);
            int size = this.getSize();
            class_1011 class_10113 = sourceImage;
            try {
                class_10112 = this.resizeWithModification(sourceImage, sourceXStart, sourceYStart, sourceSize, sourceSize, size, size);
                if (class_10113 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (class_10113 != null) {
                        try {
                            class_10113.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Exposure.LOGGER.error("Failed to process an image: {}", (Object)e.toString());
                    return null;
                }
            }
            class_10113.close();
        }
        return class_10112;
    }

    public class_1011 resizeWithModification(class_1011 source, int sourceX, int sourceY, int sourceWidth, int sourceHeight, int resultWidth, int resultHeight) {
        class_1011 result = new class_1011(source.method_4318(), resultWidth, resultHeight, false);
        for (int x = 0; x < resultWidth; ++x) {
            float ratioX = (float)x / (float)resultWidth;
            int sourcePosX = (int)((float)sourceX + (float)sourceWidth * ratioX);
            for (int y = 0; y < resultHeight; ++y) {
                float ratioY = (float)y / (float)resultHeight;
                int sourcePosY = (int)((float)sourceY + (float)sourceHeight * ratioY);
                int colorABGR = source.method_4315(sourcePosX, sourcePosY);
                for (ICaptureComponent component : this.components) {
                    colorABGR = component.modifyPixel(this, colorABGR);
                }
                result.method_4305(x, y, colorABGR);
            }
        }
        return result;
    }
}

