/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.sound;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.sound.instance.ShutterTimerTickingSoundInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1106;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;

public class OnePerPlayerSoundsClient {
    private static final Map<class_1657, List<class_1113>> instances = new HashMap<class_1657, List<class_1113>>();

    public static void play(class_1657 sourcePlayer, class_3414 soundEvent, class_3419 source, float volume, float pitch) {
        class_1937 level = sourcePlayer.method_37908();
        OnePerPlayerSoundsClient.stop(sourcePlayer, soundEvent);
        class_1113 soundInstance = OnePerPlayerSoundsClient.createSoundInstance(sourcePlayer, soundEvent, source, volume, pitch, level);
        List playingSounds = Optional.ofNullable(instances.get(sourcePlayer)).orElse(new ArrayList());
        playingSounds.add(soundInstance);
        instances.put(sourcePlayer, playingSounds);
        class_310.method_1551().method_1483().method_4873(soundInstance);
    }

    public static void stop(class_1657 sourcePlayer, class_3414 soundEvent) {
        if (instances.containsKey(sourcePlayer)) {
            class_2960 soundLocation = soundEvent.method_14833();
            List<class_1113> playingSounds = instances.remove(sourcePlayer);
            for (int i = playingSounds.size() - 1; i >= 0; --i) {
                class_1113 soundInstance = playingSounds.get(i);
                if (!soundInstance.method_4775().equals((Object)soundLocation)) continue;
                class_310.method_1551().method_1483().method_4870(soundInstance);
                playingSounds.remove(i);
            }
            instances.put(sourcePlayer, playingSounds);
        }
    }

    @NotNull
    private static class_1113 createSoundInstance(class_1657 sourcePlayer, class_3414 soundEvent, class_3419 source, float volume, float pitch, class_1937 level) {
        if (soundEvent == Exposure.SoundEvents.SHUTTER_TICKING.get()) {
            return new ShutterTimerTickingSoundInstance(sourcePlayer, soundEvent, source, volume, pitch, sourcePlayer.method_37908().method_8409());
        }
        return new class_1106(soundEvent, source, volume, pitch, (class_1297)sourcePlayer, level.method_8409().method_43055());
    }
}

