/*
 * Decompiled with CFR 0.152.
 */
package arvem.skykid.powers;

import arvem.skykid.Skykid;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.ResourcePower;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class LightManagementPower
extends Power {
    private static final int RADIUS = 3;
    private static final int UPDATE_INTERVAL = 5;
    private final Map<LightSourceType, Integer> lightSourceCache = new ConcurrentHashMap<LightSourceType, Integer>();
    private long lastCacheUpdate = 0L;
    private static final long CACHE_DURATION = 10L;
    private SerializableData.Instance DATA;
    private long lastUpdateTick = 0L;
    private ResourcePower resourcePower;

    public LightManagementPower(PowerType<?> type, class_1309 entity, SerializableData.Instance data) {
        super(type, entity);
        this.setTicking(true);
        if (!data.isPresent("resource")) {
            Skykid.LOGGER.error("No resource provided for LightManagementPower.");
            return;
        }
        this.DATA = data;
        this.resourcePower = Skykid.tryInitializeResource(entity, (PowerType)data.get("resource"));
    }

    public void tick() {
        int gainAmount;
        if (this.resourcePower == null && !this.entity.method_37908().field_9236) {
            Skykid.tryInitializeResource(this.entity, (PowerType)this.DATA.get("resource"));
            return;
        }
        if (!this.entity.method_37908().field_9236 && this.resourcePower != null && (gainAmount = this.calculateLightGain()) > 0) {
            Skykid.LOGGER.debug(String.valueOf(this.resourcePower.getValue() + gainAmount));
            this.resourcePower.setValue(this.resourcePower.getValue() + gainAmount);
            PowerHolderComponent component = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this.entity);
            component.sync();
        }
    }

    private int calculateLightGain() {
        long currentTick = this.entity.method_37908().method_8510();
        if (currentTick - this.lastUpdateTick < 5L) {
            return 0;
        }
        this.lastUpdateTick = currentTick;
        int blockLightGain = this.hasNearbyBlock(block -> block.method_26164(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_43902((String)"minecraft", (String)"candle_cakes"))) && (Boolean)block.method_11654((class_2769)class_2741.field_12548) != false) ? 40 : this.calculateBlockLightGain();
        int itemLightGain = this.calculateItemLightGain();
        return blockLightGain + itemLightGain;
    }

    private int calculateBlockLightGain() {
        int primeCount = this.countNearbyLightSources(LightSourceType.PRIME);
        int averageCount = this.countNearbyLightSources(LightSourceType.AVERAGE);
        int weakCount = this.countNearbyLightSources(LightSourceType.WEAK);
        record LightValue(int gain, int count) {
        }
        LightValue[] values = new LightValue[]{new LightValue(3, primeCount), new LightValue(2, averageCount), new LightValue(1, weakCount)};
        Arrays.sort(values, (a, b) -> Integer.compare(b.gain, a.gain));
        int totalGain = 0;
        int blocksUsed = 0;
        int maxSources = 3;
        for (LightValue value : values) {
            int remaining = Math.min(maxSources - blocksUsed, value.count);
            if (remaining > 0) {
                totalGain += remaining * value.gain;
                blocksUsed += remaining;
            }
            if (blocksUsed >= maxSources) break;
        }
        return totalGain;
    }

    private int calculateItemLightGain() {
        class_1799 mainHand = this.entity.method_6047();
        class_1799 offHand = this.entity.method_6079();
        return Math.max(this.getItemLightGain(mainHand), this.getItemLightGain(offHand));
    }

    private int getItemLightGain(class_1799 stack) {
        if (stack.method_7960()) {
            return 0;
        }
        if (stack.method_31573(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_43902((String)"skykid", (String)"prime_sources")))) {
            return 3;
        }
        if (stack.method_31573(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_43902((String)"skykid", (String)"average_sources")))) {
            return 2;
        }
        if (stack.method_31573(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_43902((String)"skykid", (String)"weak_sources")))) {
            return 1;
        }
        return 0;
    }

    private boolean hasNearbyBlock(Predicate<class_2680> predicate) {
        class_2338 entityPos = this.entity.method_24515();
        for (int x = -3; x <= 3; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    class_2338 checkPos = entityPos.method_10069(x, y, z);
                    class_2680 state = this.entity.method_37908().method_8320(checkPos);
                    if (!predicate.test(state)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private int countNearbyLightSources(LightSourceType type) {
        long currentTime = this.entity.method_37908().method_8510();
        if (currentTime - this.lastCacheUpdate >= 10L) {
            this.lightSourceCache.clear();
            this.lightSourceCache.putAll(this.scanNearbyLightSources());
            this.lastCacheUpdate = currentTime;
        }
        return this.lightSourceCache.getOrDefault((Object)type, 0);
    }

    private Map<LightSourceType, Integer> scanNearbyLightSources() {
        EnumMap<LightSourceType, Integer> counts = new EnumMap<LightSourceType, Integer>(LightSourceType.class);
        class_2338 entityPos = this.entity.method_24515();
        int radiusSquared = 9;
        for (int x = -3; x <= 3; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    if (x * x + y * y + z * z > radiusSquared) continue;
                    class_2338 checkPos = entityPos.method_10069(x, y, z);
                    class_2680 state = this.entity.method_37908().method_8320(checkPos);
                    for (LightSourceType type : LightSourceType.values()) {
                        if (!this.isValidLightSource(state, type)) continue;
                        counts.merge(type, 1, Integer::sum);
                    }
                }
            }
        }
        return counts;
    }

    private boolean isValidLightSource(class_2680 state, LightSourceType type) {
        boolean valid = false;
        switch (type) {
            case PRIME: {
                if (state.method_26164(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_43902((String)"skykid", (String)"candles")))) {
                    valid = (Boolean)state.method_11654((class_2769)class_2741.field_12548) != false && (Integer)state.method_11654((class_2769)class_2741.field_27220) >= 4;
                    break;
                }
                if (!state.method_26164(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_43902((String)"skykid", (String)"prime_sources")))) break;
                valid = true;
                break;
            }
            case AVERAGE: {
                if (state.method_26164(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_43902((String)"skykid", (String)"candles")))) {
                    valid = (Boolean)state.method_11654((class_2769)class_2741.field_12548) != false && ((Integer)state.method_11654((class_2769)class_2741.field_27220) == 2 || (Integer)state.method_11654((class_2769)class_2741.field_27220) == 3);
                    break;
                }
                if (!state.method_26164(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_43902((String)"skykid", (String)"average_sources")))) break;
                valid = true;
                break;
            }
            case WEAK: {
                if (state.method_26164(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_43902((String)"skykid", (String)"candles")))) {
                    valid = (Boolean)state.method_11654((class_2769)class_2741.field_12548) != false && (Integer)state.method_11654((class_2769)class_2741.field_27220) <= 1;
                    break;
                }
                if (!state.method_26164(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_43902((String)"skykid", (String)"weak_sources")))) break;
                valid = true;
                break;
            }
        }
        return valid;
    }

    public static PowerFactory<?> getFactory() {
        return new PowerFactory(new class_2960("skykid", "light_management"), new SerializableData().add("resource", ApoliDataTypes.POWER_TYPE, null), data -> (type, player) -> new LightManagementPower((PowerType<?>)type, (class_1309)player, (SerializableData.Instance)data)).allowCondition();
    }

    private static enum LightSourceType {
        PRIME,
        AVERAGE,
        WEAK;

    }
}

