/*
 * Decompiled with CFR 0.152.
 */
package arvem.skykid.powers;

import arvem.skykid.Skykid;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.ResourcePower;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import net.minecraft.class_1309;
import net.minecraft.class_2960;

public class LightArmorPower
extends Power {
    private static final float RESOURCE_CONSUMPTION_PER_DAMAGE = 16.0f;
    private static final float EPSILON = 1.0E-4f;
    private SerializableData.Instance DATA;
    private ResourcePower resourcePower;

    public LightArmorPower(PowerType<?> type, class_1309 entity, SerializableData.Instance data) {
        super(type, entity);
        this.setTicking(true);
        if (!data.isPresent("resource")) {
            Skykid.LOGGER.error("No resource provided for LightManagementPower.");
            return;
        }
        this.DATA = data;
        this.resourcePower = Skykid.tryInitializeResource(entity, (PowerType)data.get("resource"));
    }

    public float calculateRemainingDamage(float damageAmount) {
        float remainingDamage;
        float newResourceValue;
        if (this.resourcePower == null && this.DATA != null) {
            this.resourcePower = Skykid.tryInitializeResource(this.entity, (PowerType)this.DATA.get("resource"));
            if (this.resourcePower == null) {
                return damageAmount;
            }
        }
        if (this.resourcePower == null || damageAmount <= 0.0f || this.entity == null) {
            return damageAmount;
        }
        float damageCost = damageAmount * 16.0f;
        float value = this.resourcePower.getValue();
        if (damageCost < value + 1.0E-4f) {
            newResourceValue = value - damageCost;
            remainingDamage = 0.0f;
        } else {
            newResourceValue = 0.0f;
            remainingDamage = damageAmount - value / 16.0f;
        }
        this.resourcePower.setValue(Math.round(Math.max(0.0f, newResourceValue)));
        if (!this.entity.method_37908().field_9236 && this.entity.method_5805()) {
            PowerHolderComponent component = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this.entity);
            component.sync();
        }
        return remainingDamage;
    }

    public static PowerFactory<?> getFactory() {
        return new PowerFactory(new class_2960("skykid", "light_armor"), new SerializableData().add("resource", ApoliDataTypes.POWER_TYPE, null), data -> (type, player) -> new LightArmorPower((PowerType<?>)type, (class_1309)player, (SerializableData.Instance)data)).allowCondition();
    }
}

