/*
 * Decompiled with CFR 0.152.
 */
package com.lendill.aquila_core.util.block_families;

import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class AquilaPaletteWheelScreen
extends class_437 {
    private static final class_2960 BACKGROUND_TEXTURE = new class_2960("aquila_core", "textures/gui/aquila_palette_wheel.png");
    private final class_1799 currentBlock;
    private final List<class_1799> blocks;
    private class_1799 draggedStack = class_1799.field_8037;
    private static final int WHEEL_RADIUS = 66;
    private static final int SEGMENT_COUNT = 15;
    private int hoveredSegment = -1;
    private float[] currentYOffsets;

    public AquilaPaletteWheelScreen(class_1799 currentBlock, List<class_1799> blocks) {
        super((class_2561)class_2561.method_43471((String)"screen.aquila.palette_wheel"));
        this.currentBlock = currentBlock;
        this.blocks = blocks;
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int textureWidth = 245;
        int textureHeight = 245;
        int backgroundX = centerX - textureWidth / 2;
        int backgroundY = centerY - textureHeight / 2 + 2;
        drawContext.method_25294(0, 0, this.field_22789, this.field_22790, -2013265920);
        drawContext.method_25290(BACKGROUND_TEXTURE, backgroundX, backgroundY, 0.0f, 0.0f, textureWidth, textureHeight, textureWidth, textureHeight);
        this.renderPaletteWheel(drawContext, mouseX, mouseY, centerX, centerY, delta);
        super.method_25394(drawContext, mouseX, mouseY, delta);
    }

    private void renderPaletteWheel(class_332 drawContext, int mouseX, int mouseY, int centerX, int centerY, float delta) {
        int y;
        int x;
        double angle;
        int i;
        if (this.currentYOffsets == null || this.currentYOffsets.length != this.blocks.size()) {
            this.currentYOffsets = new float[this.blocks.size()];
            Arrays.fill(this.currentYOffsets, 0.0f);
        }
        float centerBlockScale = 2.25f;
        float defaultScale = 1.0f;
        float hoverScale = 1.5f;
        float defaultYOffset = 0.0f;
        float hoverYOffset = -5.0f;
        float lerpSpeed = 0.1f;
        class_1799 hoveredStack = class_1799.field_8037;
        if (this.currentBlock != null) {
            drawContext.method_51448().method_22903();
            drawContext.method_51448().method_46416((float)centerX - 8.0f * centerBlockScale, (float)centerY - 8.0f * centerBlockScale, 0.0f);
            drawContext.method_51448().method_22905(centerBlockScale, centerBlockScale, 1.0f);
            drawContext.method_51427(this.currentBlock, 0, 0);
            drawContext.method_51448().method_22909();
            if (this.isMouseOverItem(mouseX, mouseY, centerX, centerY, 16.0f * centerBlockScale)) {
                hoveredStack = this.currentBlock;
            }
        }
        double angleStep = 360.0 / (double)this.blocks.size();
        int hoveredIndex = -1;
        for (i = 0; i < this.blocks.size(); ++i) {
            angle = Math.toRadians(-90.0 + (double)i * angleStep);
            x = (int)((double)centerX + Math.cos(angle) * 66.0);
            if (!this.isMouseOverItem(mouseX, mouseY, x, y = (int)((double)centerY + Math.sin(angle) * 66.0), 16.0f * hoverScale)) continue;
            hoveredIndex = i;
            hoveredStack = this.blocks.get(i);
            break;
        }
        for (i = 0; i < this.blocks.size(); ++i) {
            float targetYOffset = defaultYOffset;
            if (i == hoveredIndex) {
                targetYOffset = hoverYOffset;
            }
            int n = i;
            this.currentYOffsets[n] = this.currentYOffsets[n] + (targetYOffset - this.currentYOffsets[i]) * lerpSpeed;
        }
        for (i = 0; i < this.blocks.size(); ++i) {
            angle = Math.toRadians(-90.0 + (double)i * angleStep);
            x = (int)((double)centerX + Math.cos(angle) * 66.0);
            y = (int)((double)centerY + Math.sin(angle) * 66.0);
            float scale = i == hoveredIndex ? hoverScale : defaultScale;
            drawContext.method_51448().method_22903();
            drawContext.method_51448().method_46416((float)x - 8.0f * scale, (float)y - 8.0f * scale + this.currentYOffsets[i], 0.0f);
            drawContext.method_51448().method_22905(scale, scale, 1.0f);
            drawContext.method_51427(this.blocks.get(i), 0, 0);
            drawContext.method_51448().method_22909();
        }
        if (!this.draggedStack.method_7960()) {
            hoveredStack = class_1799.field_8037;
        } else if (!hoveredStack.method_7960()) {
            List tooltip = hoveredStack.method_7950((class_1657)this.field_22787.field_1724, (class_1836)(this.field_22787.field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070));
            drawContext.method_51434(this.field_22793, tooltip, mouseX, mouseY);
        }
        if (!this.draggedStack.method_7960()) {
            drawContext.method_51448().method_22903();
            drawContext.method_51448().method_46416((float)mouseX - 8.0f * defaultScale, (float)mouseY - 8.0f * defaultScale, 0.0f);
            drawContext.method_51448().method_22905(defaultScale, defaultScale, 1.0f);
            drawContext.method_51427(this.draggedStack, 0, 0);
            drawContext.method_51448().method_22909();
        }
    }

    private boolean isMouseOverItem(double mouseX, double mouseY, int itemX, int itemY, double itemSize) {
        return mouseX >= (double)itemX - itemSize / 2.0 && mouseX <= (double)itemX + itemSize / 2.0 && mouseY >= (double)itemY - itemSize / 2.0 && mouseY <= (double)itemY + itemSize / 2.0;
    }

    public void method_16014(double mouseX, double mouseY) {
        int centerX = this.field_22789 / 2;
        double dx = mouseX - (double)centerX;
        int centerY = this.field_22790 / 2;
        double dy = mouseY - (double)centerY;
        double distance = Math.sqrt(dx * dx + dy * dy);
        if (distance <= 66.0) {
            double angle = Math.toDegrees(Math.atan2(dy, dx)) + 90.0;
            if (angle < 0.0) {
                angle += 360.0;
            }
            this.hoveredSegment = (int)(angle / 24.0);
        } else {
            this.hoveredSegment = -1;
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int centerX = this.field_22789 / 2;
            int centerY = this.field_22790 / 2;
            double angleStep = 360.0 / (double)this.blocks.size();
            for (int i = 0; i < this.blocks.size(); ++i) {
                int y;
                double angle = Math.toRadians(-90.0 + (double)i * angleStep);
                int x = (int)((double)centerX + Math.cos(angle) * 66.0);
                if (!this.isMouseOverItem(mouseX, mouseY, x, y = (int)((double)centerY + Math.sin(angle) * 66.0), 32.0)) continue;
                this.draggedStack = this.blocks.get(i);
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (!this.draggedStack.method_7960()) {
            int slot;
            if (this.isMouseOverHotbar(mouseX, mouseY) && (slot = this.getHotbarSlot(mouseX)) != -1) {
                class_310 client = class_310.method_1551();
                if (client.field_1724 != null) {
                    if (client.field_1724.method_31549().field_7477) {
                        client.field_1761.method_2909(this.draggedStack, 36 + slot);
                    } else {
                        client.field_1724.method_31548().method_5447(slot, this.draggedStack.method_7972());
                        client.field_1724.method_31548().method_5431();
                    }
                }
            }
            this.draggedStack = class_1799.field_8037;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    private boolean isMouseOverHotbar(double mouseX, double mouseY) {
        int hotbarX = (this.field_22789 - 182) / 2;
        int hotbarY = this.field_22790 - 22;
        return mouseY >= (double)hotbarY && mouseY <= (double)(hotbarY + 22);
    }

    private int getHotbarSlot(double mouseX) {
        int hotbarX = (this.field_22789 - 182) / 2;
        for (int i = 0; i < 9; ++i) {
            int slotX = hotbarX + i * 20;
            if (!(mouseX >= (double)slotX) || !(mouseX <= (double)(slotX + 20))) continue;
            return i;
        }
        return -1;
    }

    public boolean method_25421() {
        return false;
    }
}

