/*
 * Decompiled with CFR 0.152.
 */
package net.kuudraloremaster.voidscape.datagen;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.kuudraloremaster.voidscape.item.ModItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public ModRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.CYBORG_WOLF_ARMOR.get())).pattern("BPP").pattern("BRB").pattern("BSB").define(Character.valueOf('B'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('S'), (ItemLike)Items.COPPER_INGOT).define(Character.valueOf('P'), (ItemLike)Items.RED_STAINED_GLASS).define(Character.valueOf('R'), (ItemLike)Items.NETHER_STAR).unlockedBy("has_iron", ModRecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModItems.MOON_ROCKET_ITEM.get())).pattern("BBB").pattern("BGB").pattern("BLB").define(Character.valueOf('L'), (ItemLike)Items.LAVA_BUCKET).define(Character.valueOf('B'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('G'), (ItemLike)Items.GLASS_PANE).unlockedBy("has_iron", ModRecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(recipeOutput);
    }

    protected static void oreSmelting(RecipeOutput recipeOutput, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTIme, String pGroup) {
        ModRecipeProvider.oreCooking(recipeOutput, RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, pIngredients, pCategory, pResult, pExperience, pCookingTIme, pGroup, "_from_smelting");
    }

    protected static void oreBlasting(RecipeOutput recipeOutput, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup) {
        ModRecipeProvider.oreCooking(recipeOutput, RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new, pIngredients, pCategory, pResult, pExperience, pCookingTime, pGroup, "_from_blasting");
    }

    protected static <T extends AbstractCookingRecipe> void oreCooking(RecipeOutput recipeOutput, RecipeSerializer<T> pCookingSerializer, AbstractCookingRecipe.Factory<T> factory, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup, String pRecipeName) {
        for (ItemLike itemlike : pIngredients) {
            SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{itemlike}), (RecipeCategory)pCategory, (ItemLike)pResult, (float)pExperience, (int)pCookingTime, pCookingSerializer, factory).group(pGroup).unlockedBy(ModRecipeProvider.getHasName((ItemLike)itemlike), ModRecipeProvider.has((ItemLike)itemlike)).save(recipeOutput, "voidscape:" + ModRecipeProvider.getItemName((ItemLike)pResult) + pRecipeName + "_" + ModRecipeProvider.getItemName((ItemLike)itemlike));
        }
    }
}

