/*
 * Decompiled with CFR 0.152.
 */
package net.kuudraloremaster.voidscape.entity.client.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.kuudraloremaster.voidscape.item.custom.CyborgWolfArmorItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CyborgWolfArmorLayer
extends RenderLayer<Wolf, WolfModel<Wolf>> {
    private final WolfModel<Wolf> adultModel = new WolfModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.WOLF));
    private final WolfModel<Wolf> babyModel = new WolfModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.WOLF));
    private static final ResourceLocation WOLF_ARMOR_CRACKINESS_LOW = ResourceLocation.fromNamespaceAndPath((String)"voidscape", (String)"textures/entity/wolf/wolf_crackiness_low.png");
    private static final ResourceLocation WOLF_ARMOR_CRACKINESS_MEDIUM = ResourceLocation.fromNamespaceAndPath((String)"voidscape", (String)"textures/entity/wolf/wolf_crackiness_medium.png");
    private static final ResourceLocation WOLF_ARMOR_CRACKINESS_HIGH = ResourceLocation.fromNamespaceAndPath((String)"voidscape", (String)"textures/entity/wolf/wolf_crackiness_high.png");

    public CyborgWolfArmorLayer(RenderLayerParent<Wolf, WolfModel<Wolf>> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, Wolf wolf, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack armorStack = wolf.getBodyArmorItem();
        if (armorStack.isEmpty() || !(armorStack.getItem() instanceof CyborgWolfArmorItem)) {
            return;
        }
        ArmorMaterial armorMaterial = (ArmorMaterial)((CyborgWolfArmorItem)armorStack.getItem()).getMaterial().value();
        List layers = armorMaterial.layers();
        if (layers.isEmpty()) {
            return;
        }
        ArmorMaterial.Layer layer = (ArmorMaterial.Layer)layers.get(0);
        ResourceLocation textureLocation = layer.texture(false);
        ResourceLocation armorTexture = ResourceLocation.fromNamespaceAndPath((String)textureLocation.getNamespace(), (String)"textures/entity/wolf/armor/iron_wolf.png");
        WolfModel<Wolf> model = wolf.isBaby() ? this.babyModel : this.adultModel;
        ((WolfModel)this.getParentModel()).copyPropertiesTo(model);
        model.prepareMobModel(wolf, limbSwing, limbSwingAmount, partialTick);
        model.setupAnim(wolf, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)armorTexture));
        model.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
        if (armorStack.isDamaged()) {
            float damageRatio = (float)armorStack.getDamageValue() / (float)armorStack.getMaxDamage();
            ResourceLocation crackTexture = null;
            if ((double)damageRatio > 0.66) {
                crackTexture = WOLF_ARMOR_CRACKINESS_HIGH;
            } else if (damageRatio > 0.5f) {
                crackTexture = WOLF_ARMOR_CRACKINESS_MEDIUM;
            } else if (damageRatio > 0.25f) {
                crackTexture = WOLF_ARMOR_CRACKINESS_LOW;
            }
            if (crackTexture != null) {
                VertexConsumer crackConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)crackTexture));
                model.renderToBuffer(poseStack, crackConsumer, packedLight, OverlayTexture.NO_OVERLAY);
            }
        }
        if (armorStack.isEnchanted()) {
            VertexConsumer enchantConsumer = bufferSource.getBuffer(RenderType.entityGlint());
            model.renderToBuffer(poseStack, enchantConsumer, packedLight, OverlayTexture.NO_OVERLAY);
        }
    }
}

