/*
 * Decompiled with CFR 0.152.
 */
package net.kuudraloremaster.voidscape.entity.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.kuudraloremaster.voidscape.entity.client.ModModelLayers;
import net.kuudraloremaster.voidscape.entity.client.render.MoonRocketModel;
import net.kuudraloremaster.voidscape.entity.vehicle.MoonRocketEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class MoonRocketRenderer
extends EntityRenderer<MoonRocketEntity> {
    private final MoonRocketModel model;

    public MoonRocketRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new MoonRocketModel(context.bakeLayer(ModModelLayers.MOON_ROCKET_MODEL));
    }

    public ResourceLocation getTextureLocation(MoonRocketEntity moonRocketEntity) {
        return ResourceLocation.fromNamespaceAndPath((String)"voidscape", (String)"textures/entity/moon_rocket/moon_rocket.png");
    }

    public void render(MoonRocketEntity p_entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        VertexConsumer bodyBuffer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureLocation(p_entity)));
        poseStack.scale(2.3f, -2.3f, 2.3f);
        poseStack.translate(0.0f, 0.0f, 0.0f);
        this.model.getRocket().render(poseStack, bodyBuffer, packedLight, OverlayTexture.NO_OVERLAY);
        VertexConsumer glassBuffer = bufferSource.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)this.getTextureLocation(p_entity)));
        this.model.getWindow().render(poseStack, glassBuffer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((Entity)p_entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }
}

