/*
 * Decompiled with CFR 0.152.
 */
package net.kuudraloremaster.voidscape.entity.vehicle;

import net.kuudraloremaster.voidscape.Voidscape;
import net.kuudraloremaster.voidscape.event.VoidscapeEvents;
import net.kuudraloremaster.voidscape.item.ModItems;
import net.kuudraloremaster.voidscape.util.VoidscapeUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;

public class MoonRocketEntity
extends VehicleEntity {
    private static final double TARGET_HEIGHT = 450.0;
    private static final double THRUST_INCREASE = 5.0E-4;
    double verticalVelocity = 0.0;
    private double currentThrust = 0.0;
    private int launchTicks = 0;
    public Entity passengera;
    ResourceKey<Level> MOON_DIMENSION = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"voidscape", (String)"moon"));

    public MoonRocketEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.addAdditionalSaveData(this.getPersistentData());
        this.refreshDimensions();
        VoidscapeEvents.alreadyLaunched = false;
    }

    protected void positionRider(Entity passenger, Entity.MoveFunction callback) {
        if (this.hasPassenger(passenger)) {
            Vec3 worldPos = new Vec3(this.position().x, Mth.lerp((double)this.currentThrust, (double)this.position().y, (double)450.0), this.position().z);
            callback.accept(passenger, worldPos.x, worldPos.y, worldPos.z);
        }
    }

    protected void removePassenger(Entity passenger) {
        if (passenger instanceof Player) {
            if (this.getPersistentData().getBoolean("launching")) {
                return;
            }
            super.removePassenger(passenger);
        } else {
            super.removePassenger(passenger);
        }
    }

    public double getLaunchProgress() {
        if (!this.getPersistentData().getBoolean("launching")) {
            return 0.0;
        }
        return Math.min(1.0, (double)this.launchTicks / 200.0);
    }

    public void initiateLaunch() {
        if (!this.getPersistentData().getBoolean("launching")) {
            this.getPersistentData().putBoolean("launching", true);
            this.currentThrust = 0.0;
            this.verticalVelocity = 0.1;
            this.launchTicks = 0;
            this.setNoGravity(true);
        }
    }

    public boolean isNoGravity() {
        return this.getPersistentData().getBoolean("launched") || super.isNoGravity();
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            return;
        }
        if (this.getPersistentData().getBoolean("launching")) {
            Vec3 currentPos = this.position();
            if (this.launchTicks % 20 == 0) {
                System.out.println("ROCKET: Launching! Ticks: " + this.launchTicks + ", Height: " + this.position().y);
            }
            if (currentPos.y >= 410.0) {
                this.getPersistentData().putBoolean("launching", false);
                this.getPersistentData().putBoolean("falling", true);
                this.currentThrust = 0.0;
                this.launchTicks = 0;
                VoidscapeEvents.alreadyLaunched = false;
                Vec3 currentVel = this.getDeltaMovement();
                this.setDeltaMovement(currentVel.multiply(0.0, 0.95, 0.0));
                if (this.level().dimension() == Level.OVERWORLD) {
                    VoidscapeUtil.teleportEntityWithPassengers(this.getServer().getLevel(this.MOON_DIMENSION), (Entity)this, this.getX(), this.getY(), this.getZ(), this.yRotO, this.xRotO);
                } else if (this.level().dimension() == this.MOON_DIMENSION) {
                    VoidscapeUtil.teleportEntityWithPassengers(this.getServer().getLevel(Level.OVERWORLD), (Entity)this, this.getX(), this.getY(), this.getZ(), this.yRotO, this.xRotO);
                }
                return;
            }
            ++this.launchTicks;
            this.currentThrust += 5.0E-4;
            this.setDeltaMovement(this.getDeltaMovement().x, Mth.lerp((double)Minecraft.getInstance().getTimer().getGameTimeDeltaTicks(), (double)this.position().y, (double)450.0), this.getDeltaMovement().z);
            this.moveTo(this.position().x, Mth.lerp((double)this.currentThrust, (double)this.position().y, (double)450.0), this.position().z);
            this.positionRider(this.getFirstPassenger());
            this.hasImpulse = true;
            if (this.level().isClientSide && this.launchTicks % 5 == 0) {
                this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.position().x, this.position().y, this.position().z, this.position().scale((double)1.0).x, this.position().scale((double)1.0).y, this.position().scale((double)1.0).z);
            }
        }
        if (this.getPersistentData().getBoolean("falling")) {
            this.getPersistentData().putBoolean("launching", false);
            BlockPos nearestBlock = VoidscapeUtil.findNearestSolidBlockUnderEntity((Entity)this, 500);
            this.moveTo(this.position().x, Mth.lerp((double)this.currentThrust, (double)nearestBlock.getY(), (double)this.getY()), this.position().z);
            Voidscape.LOGGER.info(this.currentThrust + "thrusting it while falling");
            Voidscape.LOGGER.info(String.valueOf(nearestBlock) + "nereastblock under entity while falling");
            Voidscape.LOGGER.info(this.getY() + "ntity y value while falling");
            this.hasImpulse = true;
            if (this.getY() + 1.0 == (double)(nearestBlock.getY() + 1)) {
                this.getPersistentData().putBoolean("falling", false);
                this.setDeltaMovement(Vec3.ZERO);
                this.setNoGravity(false);
            }
        }
        if (!(this.getPersistentData().getBoolean("falling") || this.getPersistentData().getBoolean("launching") || !(this.currentThrust > 0.0) && this.launchTicks <= 0)) {
            this.currentThrust = 0.0;
            this.launchTicks = 0;
            this.setNoGravity(false);
        }
    }

    protected void positionRiderA(Entity passenger, Entity.MoveFunction callback) {
        Vec3 vec3 = this.getPassengerRidingPosition(passenger);
        Vec3 vec31 = passenger.getVehicleAttachmentPoint((Entity)this);
        callback.accept(passenger, vec3.x - vec31.x, vec3.y - vec31.y, vec3.z - vec31.z);
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float partialTick) {
        return new Vec3(0.0, 0.3, 0.0);
    }

    protected boolean canAddPassenger(Entity passenger) {
        return this.getPassengers().isEmpty();
    }

    protected void addPassenger(Entity passenger) {
        this.passengera = passenger;
        super.addPassenger(passenger);
    }

    protected boolean canRide(Entity vehicle) {
        return true;
    }

    public boolean canRiderInteract() {
        return false;
    }

    public boolean shouldRiderSit() {
        return true;
    }

    public boolean isPickable() {
        return true;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    public boolean isPushable() {
        return true;
    }

    protected Item getDropItem() {
        return (Item)ModItems.MOON_ROCKET_ITEM.get();
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        compoundTag.putInt("fuel", 0);
        compoundTag.putBoolean("launching", false);
        compoundTag.putBoolean("falling", false);
    }

    public EntityDimensions getDimensions(Pose pose) {
        return EntityDimensions.scalable((float)2.5f, (float)3.5f);
    }
}

