/*
 * Decompiled with CFR 0.152.
 */
package net.kuudraloremaster.voidscape.event;

import net.kuudraloremaster.voidscape.Voidscape;
import net.kuudraloremaster.voidscape.client.ModKeyMappings;
import net.kuudraloremaster.voidscape.entity.vehicle.MoonRocketEntity;
import net.kuudraloremaster.voidscape.item.custom.CyborgWolfArmorItem;
import net.kuudraloremaster.voidscape.network.payload.LaunchRocketPacket;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="voidscape", bus=EventBusSubscriber.Bus.GAME)
public class VoidscapeEvents {
    public static boolean alreadyLaunched = false;

    @SubscribeEvent
    public static void handleEntityDamage(LivingDamageEvent.Pre event) {
        ResourceKey MOON_DIMENSION = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"voidscape", (String)"moon"));
        if (event.getSource().is(DamageTypes.FALL) && event.getEntity().level().dimension() == MOON_DIMENSION) {
            event.setNewDamage(0.0f);
        }
    }

    @SubscribeEvent
    public static void onLivingDamageCalculate(LivingIncomingDamageEvent event) {
        Item item;
        Wolf wolf;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Wolf) || !(wolf = (Wolf)livingEntity).isTame()) {
            return;
        }
        ItemStack armorStack = wolf.getBodyArmorItem();
        if (armorStack.isEmpty() || !((item = armorStack.getItem()) instanceof CyborgWolfArmorItem)) {
            return;
        }
        CyborgWolfArmorItem wolfArmor = (CyborgWolfArmorItem)item;
        DamageSource damageSource = event.getSource();
        if (damageSource.is(DamageTypeTags.BYPASSES_ARMOR) || damageSource.is(DamageTypes.STARVE) || damageSource.is(DamageTypes.DROWN) || damageSource.is(DamageTypes.FREEZE) || damageSource.is(DamageTypes.MAGIC) || damageSource.is(DamageTypes.WITHER)) {
            return;
        }
        float originalDamage = event.getAmount();
        if (originalDamage > 0.0f) {
            int damageToArmor;
            int currentDurability = armorStack.getMaxDamage() - armorStack.getDamageValue();
            if (currentDurability > (damageToArmor = Math.max(1, (int)Math.ceil(originalDamage)))) {
                armorStack.hurtAndBreak(damageToArmor, (LivingEntity)wolf, EquipmentSlot.BODY);
                event.setAmount(0.0f);
            } else {
                float remainingDamage = originalDamage - (float)currentDurability;
                armorStack.hurtAndBreak(currentDurability, (LivingEntity)wolf, EquipmentSlot.BODY);
                wolf.setBodyArmorItem(ItemStack.EMPTY);
                wolf.playSound(SoundEvents.ITEM_BREAK);
                event.setAmount(Math.max(0.0f, remainingDamage));
            }
        }
    }

    @SubscribeEvent
    public static void interact(PlayerInteractEvent.EntityInteract event) {
        Wolf wolf;
        Player player = event.getEntity();
        Entity entity = event.getTarget();
        if (entity instanceof Wolf && (wolf = (Wolf)entity).isTame() && wolf.isOwnedBy((LivingEntity)player)) {
            ItemStack stack = event.getItemStack();
            ItemStack armor = wolf.getBodyArmorItem();
            if (armor.isEmpty()) {
                if (stack.getItem() instanceof CyborgWolfArmorItem) {
                    if (!event.getTarget().level().isClientSide()) {
                        wolf.setBodyArmorItem(stack.copyWithCount(1));
                        stack.consume(1, (LivingEntity)player);
                    }
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                }
            } else {
                CyborgWolfArmorItem wolfArmor;
                Item item;
                int factor = 8;
                if (wolf.isInSittingPose() && armor.isDamaged() && factor > 0 && (item = armor.getItem()) instanceof CyborgWolfArmorItem && ((Ingredient)((ArmorMaterial)(wolfArmor = (CyborgWolfArmorItem)item).getMaterial().value()).repairIngredient().get()).test(stack)) {
                    if (!event.getTarget().level().isClientSide() && !player.getAbilities().instabuild) {
                        stack.shrink(1);
                        wolf.playSound(SoundEvents.WOLF_ARMOR_REPAIR);
                        armor.setDamageValue(Math.max(0, armor.getDamageValue() - armor.getMaxDamage() / factor));
                    } else if (player.getAbilities().instabuild && !event.getTarget().level().isClientSide) {
                        wolf.playSound(SoundEvents.WOLF_ARMOR_REPAIR);
                        armor.setDamageValue(Math.max(0, armor.getDamageValue() - armor.getMaxDamage() / factor));
                    }
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                }
                if (stack.is(Items.SHEARS)) {
                    wolf.setBodyArmorItem(ItemStack.EMPTY);
                    if (!player.getAbilities().instabuild && !player.getInventory().add(armor)) {
                        player.drop(armor, false);
                    }
                    wolf.playSound(SoundEvents.SHEEP_SHEAR);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                }
            }
        }
        if ((entity = event.getTarget()) instanceof MoonRocketEntity) {
            MoonRocketEntity entity2 = (MoonRocketEntity)entity;
            Voidscape.LOGGER.info("player interacted with moon rocket");
            player = event.getEntity();
            player.startRiding((Entity)entity2);
            Minecraft.getInstance().options.setCameraType(CameraType.THIRD_PERSON_FRONT);
        }
    }

    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent.Pre event) {
        LivingEntity livingEntity;
        AttributeInstance attributeInstance;
        Entity entity = event.getEntity();
        ResourceKey levelResourceKey = entity.level().dimension();
        ResourceKey MOON_DIMENSION = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"voidscape", (String)"moon"));
        if (entity instanceof LivingEntity && (attributeInstance = (livingEntity = (LivingEntity)entity).getAttribute(Attributes.GRAVITY)) != null) {
            if (levelResourceKey == MOON_DIMENSION) {
                attributeInstance.setBaseValue(0.02);
            } else {
                attributeInstance.setBaseValue(((Attribute)Attributes.GRAVITY.value()).getDefaultValue());
            }
        }
    }

    @SubscribeEvent
    public static void keyPress(InputEvent.Key event) {
        Minecraft mc = Minecraft.getInstance();
        if (event.getAction() != 1) {
            return;
        }
        if (mc.player != null && mc.player.getVehicle() instanceof MoonRocketEntity && event.getKey() == ModKeyMappings.rocketLaunch.getKey().getValue() && !alreadyLaunched) {
            alreadyLaunched = true;
            Voidscape.LOGGER.info("And we have liftoff!! (hopefully)");
            Voidscape.LOGGER.info("already launched? {}", (Object)alreadyLaunched);
            PacketDistributor.sendToServer((CustomPacketPayload)new LaunchRocketPacket("launch", mc.player.getVehicle().getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

