/*
 * Decompiled with CFR 0.152.
 */
package net.kuudraloremaster.voidscape.network.payload;

import java.util.UUID;
import net.kuudraloremaster.voidscape.util.VoidscapeUtil;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record LaunchRocketPacket(String name, UUID entity) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<LaunchRocketPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"voidscape", (String)"rocket_launch"));
    public static final StreamCodec<RegistryFriendlyByteBuf, LaunchRocketPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, LaunchRocketPacket::name, (StreamCodec)UUIDUtil.STREAM_CODEC, LaunchRocketPacket::entity, LaunchRocketPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleRocketLaunch(LaunchRocketPacket payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)patt0$temp;
                VoidscapeUtil.handleRocketLaunch(sp, payload.entity());
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.literal((String)("Action Failed:  " + e.getMessage())));
            return null;
        });
    }
}

