/*
 * Decompiled with CFR 0.152.
 */
package net.kuudraloremaster.voidscape.util;

import java.util.ArrayList;
import java.util.UUID;
import net.kuudraloremaster.voidscape.Voidscape;
import net.kuudraloremaster.voidscape.entity.vehicle.MoonRocketEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.DimensionTransition;

public class VoidscapeUtil {
    public static void handleRocketLaunch(ServerPlayer sp, UUID uuid) {
        ServerLevel serverLevel = sp.getServer().getLevel(sp.level().dimension());
        Entity entity = serverLevel.getEntity(uuid);
        if (entity instanceof MoonRocketEntity) {
            MoonRocketEntity rocketEntity = (MoonRocketEntity)entity;
            if (sp.getVehicle() != null && sp.getVehicle().getUUID().equals(uuid)) {
                Voidscape.LOGGER.info("sent rocket launch request");
                rocketEntity.initiateLaunch();
                Voidscape.LOGGER.info("launching is true");
                Voidscape.LOGGER.info("Rocket entity found and launch initiated for player: {}", (Object)sp.getName().getString());
            } else {
                Voidscape.LOGGER.warn("Player {} is not riding the rocket with UUID {}", (Object)sp.getName().getString(), (Object)uuid);
            }
        } else {
            Voidscape.LOGGER.warn("Entity with UUID {} is not a MoonRocketEntity or doesn't exist", (Object)uuid);
        }
    }

    public static boolean teleportEntityWithPassengers(ServerLevel targetLevel, Entity vehicle, double x, double y, double z, float yaw, float pitch) {
        ResourceKey targetDim;
        ArrayList passengers = new ArrayList(vehicle.getPassengers());
        for (Entity p : passengers) {
            if (p.hasPassenger(vehicle)) continue;
            p.stopRiding();
        }
        ResourceKey currentDim = vehicle.level().dimension();
        if (currentDim == (targetDim = targetLevel.dimension())) {
            vehicle.teleportTo(x, y, z);
            vehicle.setYRot(yaw);
            vehicle.setXRot(pitch);
        } else if (!(vehicle instanceof ServerPlayer)) {
            DimensionTransition dimensionTransition = new DimensionTransition(targetLevel, vehicle, DimensionTransition.DO_NOTHING);
            Entity newVehicle = vehicle.changeDimension(dimensionTransition);
            if (newVehicle == null) {
                return false;
            }
            vehicle = newVehicle;
            vehicle.teleportTo(x, y, z);
        } else {
            ((ServerPlayer)vehicle).teleportTo(targetLevel, x, y, z, yaw, pitch);
        }
        for (Entity p : passengers) {
            if (p instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)p;
                serverPlayer.teleportTo(targetLevel, x, y, z, serverPlayer.getYRot(), serverPlayer.getXRot());
            } else {
                if (p.level().dimension() != targetLevel.dimension()) {
                    DimensionTransition dimensionTransition = new DimensionTransition(targetLevel, p, DimensionTransition.DO_NOTHING);
                    Entity newP = p.changeDimension(dimensionTransition);
                    if (newP == null) continue;
                    p = newP;
                }
                p.teleportTo(x, y, z);
            }
            p.setYRot(yaw);
            p.setXRot(pitch);
        }
        Entity currentMount = vehicle;
        for (Entity p : passengers) {
            p.startRiding(currentMount, true);
            currentMount = p;
        }
        vehicle.setPos(x, y, z);
        vehicle.hurtMarked = true;
        return true;
    }

    public static BlockPos findNearestSolidBlockUnderEntity(Entity entity, int maxSearchDistance) {
        Level level = entity.level();
        BlockPos entityPos = entity.blockPosition();
        for (int i = 0; i < maxSearchDistance; ++i) {
            BlockPos checkPos = entityPos.below(i);
            BlockState blockState = level.getBlockState(checkPos);
            if (!blockState.isSolidRender((BlockGetter)level, checkPos) || blockState.isAir()) continue;
            return checkPos;
        }
        return null;
    }
}

