/*
 * Decompiled with CFR 0.152.
 */
package chappie.displaycase.client.tile;

import chappie.displaycase.common.tile.DisplayCaseTileEntity;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class DisplayCaseRenderer
implements BlockEntityRenderer<DisplayCaseTileEntity> {
    public static final Map<DyeColor, Block> ITEM_BY_DYE = (Map)Util.make((Object)Maps.newEnumMap(DyeColor.class), map -> {
        map.put(DyeColor.WHITE, Blocks.WHITE_STAINED_GLASS);
        map.put(DyeColor.ORANGE, Blocks.ORANGE_STAINED_GLASS);
        map.put(DyeColor.MAGENTA, Blocks.MAGENTA_STAINED_GLASS);
        map.put(DyeColor.LIGHT_BLUE, Blocks.LIGHT_BLUE_STAINED_GLASS);
        map.put(DyeColor.YELLOW, Blocks.YELLOW_STAINED_GLASS);
        map.put(DyeColor.LIME, Blocks.LIME_STAINED_GLASS);
        map.put(DyeColor.PINK, Blocks.PINK_STAINED_GLASS);
        map.put(DyeColor.GRAY, Blocks.GRAY_STAINED_GLASS);
        map.put(DyeColor.LIGHT_GRAY, Blocks.LIGHT_GRAY_STAINED_GLASS);
        map.put(DyeColor.CYAN, Blocks.CYAN_STAINED_GLASS);
        map.put(DyeColor.PURPLE, Blocks.PURPLE_STAINED_GLASS);
        map.put(DyeColor.BLUE, Blocks.BLUE_STAINED_GLASS);
        map.put(DyeColor.BROWN, Blocks.BROWN_STAINED_GLASS);
        map.put(DyeColor.GREEN, Blocks.GREEN_STAINED_GLASS);
        map.put(DyeColor.RED, Blocks.RED_STAINED_GLASS);
        map.put(DyeColor.BLACK, Blocks.BLACK_STAINED_GLASS);
    });

    public DisplayCaseRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    public void render(DisplayCaseTileEntity tileEntityIn, float partialTicks, PoseStack matrix, MultiBufferSource bufferIn, int packedLight, int packedOverlay, Vec3 vec3) {
        ItemStack stack;
        matrix.pushPose();
        if (tileEntityIn.hasLid()) {
            matrix.pushPose();
            matrix.translate(0.5f, 0.625f, 0.5f);
            Minecraft.getInstance().getItemRenderer().renderStatic(tileEntityIn.getLidItem(), ItemDisplayContext.NONE, packedLight, OverlayTexture.NO_OVERLAY, matrix, bufferIn, null, 0);
            matrix.popPose();
        }
        if ((stack = tileEntityIn.getItem()) != null && !stack.isEmpty()) {
            matrix.translate(0.5, 0.25, 0.5);
            if (!Minecraft.getInstance().isPaused()) {
                tileEntityIn.rotTick();
            }
            float f1 = Minecraft.getInstance().isPaused() || tileEntityIn.isWaxed() ? 0.0f : partialTicks;
            float f = (float)tileEntityIn.getRot() + f1;
            matrix.mulPose((Quaternionfc)Axis.YP.rotation(f / 50.0f));
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, packedLight, OverlayTexture.NO_OVERLAY, matrix, bufferIn, null, 0);
        }
        matrix.popPose();
    }
}

