/*
 * Decompiled with CFR 0.152.
 */
package chappie.displaycase.common.tile;

import chappie.displaycase.Constants;
import chappie.displaycase.common.criterions.ExplosionOfDisplayCaseTrigger;
import chappie.displaycase.common.items.DisplayCaseItem;
import chappie.displaycase.common.items.DisplayCaseLidItem;
import chappie.displaycase.common.items.ModItems;
import chappie.displaycase.common.tile.ModTileEntities;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;

public class DisplayCaseTileEntity
extends BlockEntity {
    private int rot = 0;
    private int timeToBoom = 0;
    private ItemStack itemInDisplay = ItemStack.EMPTY;
    private ItemStack lidItem = ModItems.DISPLAY_CASE_LID.getDefaultInstance();
    private boolean waxed = false;

    public DisplayCaseTileEntity(BlockPos pos, BlockState state) {
        super(ModTileEntities.DISPLAY_CASE, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, DisplayCaseTileEntity tile) {
        if (tile.timeToBoom > 0) {
            --tile.timeToBoom;
        }
        if (tile.timeToBoom == 1 && !level.isClientSide()) {
            level.explode(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 3.0f, Level.ExplosionInteraction.BLOCK);
            for (ServerPlayer entity : level.getEntitiesOfClass(ServerPlayer.class, new AABB(pos.getCenter(), pos.getCenter()).inflate(10.0, 10.0, 10.0))) {
                ExplosionOfDisplayCaseTrigger.INSTANCE.trigger(entity);
            }
        }
    }

    public void rotTick() {
        if (this.level == null) {
            return;
        }
        if (!this.waxed) {
            ++this.rot;
        }
    }

    public DyeColor getColor() {
        PlayerHeadItem item;
        Item item2 = this.getItem().getItem();
        if (item2 instanceof PlayerHeadItem && (item = (PlayerHeadItem)item2).getName(this.getItem()).toString().equals("ChappiePie")) {
            return DyeColor.values()[this.rot % 75 / 5];
        }
        if (this.lidItem != null && !this.lidItem.isEmpty()) {
            return (DyeColor)this.lidItem.get(DataComponents.BASE_COLOR);
        }
        return null;
    }

    public void setColor(DyeColor color) {
        if (this.lidItem != null) {
            if (color == null) {
                this.lidItem.remove(DataComponents.BASE_COLOR);
            } else {
                this.lidItem.set(DataComponents.BASE_COLOR, (Object)color);
            }
        }
        this.markUpdated();
    }

    public boolean hasLid() {
        return this.lidItem != null && this.lidItem.getItem() instanceof DisplayCaseLidItem;
    }

    public ItemStack getLidItem() {
        return this.lidItem;
    }

    public void setLidItem(ItemStack lidItem) {
        this.lidItem = lidItem;
        this.markUpdated();
    }

    public int getRot() {
        return this.rot;
    }

    public boolean isWaxed() {
        return this.waxed;
    }

    public void setWaxed(boolean waxed) {
        this.waxed = waxed;
        this.markUpdated();
    }

    public ItemStack getItem() {
        return this.itemInDisplay;
    }

    public boolean setItem(ItemStack stack) {
        if (this.timeToBoom > 0) {
            return false;
        }
        this.itemInDisplay = stack;
        if (!stack.isEmpty()) {
            this.itemInDisplay.setCount(1);
        }
        if (stack.getItem() instanceof DisplayCaseItem && this.level != null) {
            ItemStack stack1 = stack;
            boolean shouldBoom = false;
            for (int i = 0; i < 11 && stack1.get(DataComponents.BLOCK_ENTITY_DATA) != null; ++i) {
                CustomData data = (CustomData)stack1.get(DataComponents.BLOCK_ENTITY_DATA);
                try (ProblemReporter.ScopedCollector problemreporter$scopedcollector = new ProblemReporter.ScopedCollector(this.problemPath(), Constants.LOG);){
                    ItemStack displayCaseIn = TagValueInput.create((ProblemReporter)problemreporter$scopedcollector, (HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)data.copyTag()).read("item_in_display", ItemStack.CODEC).orElse(ItemStack.EMPTY);
                    if (i == 9) {
                        shouldBoom = true;
                        break;
                    }
                    if (!(displayCaseIn.getItem() instanceof DisplayCaseItem)) break;
                    stack1 = displayCaseIn;
                    continue;
                }
            }
            if (shouldBoom) {
                if (this.level != null) {
                    this.level.playSound(null, this.getBlockPos(), SoundEvents.GOAT_SCREAMING_DEATH, SoundSource.BLOCKS, 4.0f, 1.0f);
                }
                this.timeToBoom = 160;
            }
        }
        this.markUpdated();
        return true;
    }

    public void markUpdated() {
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveCustomOnly(pRegistries);
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putBoolean("waxed", this.waxed);
        if (!this.itemInDisplay.isEmpty()) {
            output.storeNullable("item_in_display", ItemStack.CODEC, (Object)this.itemInDisplay);
        }
        if (this.lidItem != null && !this.lidItem.isEmpty()) {
            output.storeNullable("lid_item", ItemStack.CODEC, (Object)this.lidItem);
        } else {
            output.putString("nothing", "");
        }
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.waxed = input.getBooleanOr("waxed", false);
        this.itemInDisplay = input.read("item_in_display", ItemStack.CODEC).orElse(ItemStack.EMPTY);
        Optional lidItem = input.read("lid_item", ItemStack.CODEC);
        this.lidItem = lidItem.isEmpty() && input.getString("nothing").isEmpty() ? ModItems.DISPLAY_CASE_LID.getDefaultInstance() : (input.getString("nothing").isPresent() ? null : (ItemStack)input.read("lid_item", ItemStack.CODEC).orElse(null));
    }
}

