/*
 * Decompiled with CFR 0.152.
 */
package chappie.displaycase;

import chappie.displaycase.CommonClass;
import chappie.displaycase.client.tile.DisplayCaseRenderer;
import chappie.displaycase.common.blocks.ModBlocks;
import chappie.displaycase.common.items.ModItems;
import chappie.displaycase.common.recipe.ModRecipes;
import chappie.displaycase.common.tile.ModTileEntities;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Items;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

@Mod(value="display_case")
public class DisplayCaseMod {
    public DisplayCaseMod(FMLJavaModLoadingContext context) {
        BusGroup modBusGroup = context.getModBusGroup();
        CommonClass.init();
        RegisterEvent.getBus((BusGroup)modBusGroup).addListener(this::register);
        BuildCreativeModeTabContentsEvent.getBus((BusGroup)modBusGroup).addListener(this::buildContents);
        EntityRenderersEvent.RegisterRenderers.getBus((BusGroup)modBusGroup).addListener(this::registerRenderers);
    }

    private void register(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.BLOCKS, helper -> ModBlocks.registerBlocks((t, r) -> helper.register(r, t)));
        event.register(ForgeRegistries.Keys.ITEMS, helper -> ModItems.registerItems((t, r) -> helper.register(r, t)));
        event.register(ForgeRegistries.Keys.BLOCK_ENTITY_TYPES, helper -> ModTileEntities.registerTiles((t, r) -> helper.register(r, t)));
        event.register(ForgeRegistries.Keys.RECIPE_SERIALIZERS, helper -> ModRecipes.register((t, r) -> helper.register(r, t), CriteriaTriggers::register));
    }

    private void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(ModTileEntities.DISPLAY_CASE, DisplayCaseRenderer::new);
    }

    private void buildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == ((Holder.Reference)BuiltInRegistries.CREATIVE_MODE_TAB.get(CreativeModeTabs.FUNCTIONAL_BLOCKS).get()).get()) {
            event.getEntries().putBefore((Object)Items.LOOM.getDefaultInstance(), (Object)ModItems.DISPLAY_CASE.getDefaultInstance(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }
}

