/*
 * Decompiled with CFR 0.152.
 */
package chappie.displaycase.client.items;

import chappie.displaycase.Constants;
import chappie.displaycase.common.blocks.ModBlocks;
import chappie.displaycase.common.items.DisplayCaseItem;
import chappie.displaycase.common.items.ModItems;
import chappie.displaycase.common.tile.DisplayCaseTileEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.MapCodec;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.TagValueInput;
import org.joml.Vector3f;

public class DisplayCaseItemRenderer
implements SpecialModelRenderer<ItemStack> {
    private final DisplayCaseTileEntity displayCaseTileEntity = new DisplayCaseTileEntity(BlockPos.ZERO, ModBlocks.DISPLAY_CASE.defaultBlockState());

    public void render(ItemStack itemStack, ItemDisplayContext itemDisplayContext, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int overlay, boolean hasFoilType) {
        poseStack.pushPose();
        if (itemStack.getItem() instanceof DisplayCaseItem) {
            CompoundTag compoundtag = ((CustomData)itemStack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag();
            try (ProblemReporter.ScopedCollector problemreporter$scopedcollector = new ProblemReporter.ScopedCollector(this.displayCaseTileEntity.problemPath(), Constants.LOG);){
                this.displayCaseTileEntity.loadWithComponents(TagValueInput.create((ProblemReporter)problemreporter$scopedcollector, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), (CompoundTag)compoundtag));
                if (this.displayCaseTileEntity.getLevel() == null) {
                    this.displayCaseTileEntity.setLevel((Level)Minecraft.getInstance().level);
                }
            }
            if (compoundtag.isEmpty() && !this.displayCaseTileEntity.hasLid()) {
                this.displayCaseTileEntity.setLidItem(ModItems.DISPLAY_CASE_LID.getDefaultInstance());
            }
        }
        Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer((BlockEntity)this.displayCaseTileEntity).render((BlockEntity)this.displayCaseTileEntity, Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(false), poseStack, multiBufferSource, packedLight, OverlayTexture.NO_OVERLAY, Minecraft.getInstance().getCameraEntity().position());
        poseStack.popPose();
    }

    public void getExtents(Set<Vector3f> set) {
    }

    public ItemStack extractArgument(ItemStack itemStack) {
        return itemStack;
    }

    public record Unbaked() implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = MapCodec.unit(Unbaked::new);

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        public SpecialModelRenderer<?> bake(EntityModelSet modelSet) {
            return new DisplayCaseItemRenderer();
        }
    }
}

