/*
 * Decompiled with CFR 0.152.
 */
package net.ppekkungz.waypointwarp.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Map;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2277;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import net.ppekkungz.waypointwarp.data.Waypoint;
import net.ppekkungz.waypointwarp.data.state.WaypointPersistentState;
import net.ppekkungz.waypointwarp.data.tick.WaypointTickHandler;

public class WaypointCommands {
    private static final SuggestionProvider<class_2168> ENTITY_SUGGESTIONS = (ctx, builder) -> class_2172.method_9270((Iterable)class_7923.field_41177.method_10235(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<class_2168> PARTICLE_SUGGESTIONS = (ctx, builder) -> class_2172.method_9270((Iterable)class_7923.field_41180.method_10235(), (SuggestionsBuilder)builder);

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"waypoint").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"fromPos", (ArgumentType)class_2277.method_9737()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"toPos", (ArgumentType)class_2277.method_9737()).executes(ctx -> WaypointCommands.executeSet((CommandContext<class_2168>)ctx, null, null, 0.0))).then(class_2170.method_9247((String)"summon").then(class_2170.method_9244((String)"entityId", (ArgumentType)class_2232.method_9441()).suggests(ENTITY_SUGGESTIONS).then(class_2170.method_9244((String)"dy", (ArgumentType)DoubleArgumentType.doubleArg()).executes(ctx -> WaypointCommands.executeSet((CommandContext<class_2168>)ctx, class_2232.method_9443((CommandContext)ctx, (String)"entityId").toString(), null, DoubleArgumentType.getDouble((CommandContext)ctx, (String)"dy"))))))).then(class_2170.method_9247((String)"particle").then(class_2170.method_9244((String)"particleId", (ArgumentType)class_2232.method_9441()).suggests(PARTICLE_SUGGESTIONS).executes(ctx -> WaypointCommands.executeSet((CommandContext<class_2168>)ctx, null, class_2232.method_9443((CommandContext)ctx, (String)"particleId").toString(), 0.0))))))))).then(class_2170.method_9247((String)"edit").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9247((String)"from").then(class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9737()).executes(WaypointCommands::executeEditFrom)))).then(class_2170.method_9247((String)"to").then(class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9737()).executes(WaypointCommands::executeEditTo)))).then(class_2170.method_9247((String)"radius").then(class_2170.method_9244((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)0.1)).executes(WaypointCommands::executeEditRadius)))).then(class_2170.method_9247((String)"particle").then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests(PARTICLE_SUGGESTIONS).executes(WaypointCommands::executeEditParticle)))).then(class_2170.method_9247((String)"summon").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2232.method_9441()).suggests(ENTITY_SUGGESTIONS).then(class_2170.method_9244((String)"dy", (ArgumentType)DoubleArgumentType.doubleArg()).executes(WaypointCommands::executeEditSummon))))))).then(class_2170.method_9247((String)"distance").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"radius", (ArgumentType)DoubleArgumentType.doubleArg((double)0.1)).executes(WaypointCommands::executeDistance))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(WaypointCommands::executeRemove)))).then(class_2170.method_9247((String)"list").executes(WaypointCommands::executeList))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"debug").then(class_2170.method_9247((String)"mspt").executes(WaypointCommands::executeDebugMspt))).then(class_2170.method_9247((String)"active").executes(WaypointCommands::executeDebugActive)))));
    }

    private static int executeSet(CommandContext<class_2168> ctx, String summonId, String particleId, double dy) {
        class_2168 src = (class_2168)ctx.getSource();
        String name = StringArgumentType.getString(ctx, (String)"name");
        class_243 pos1 = class_2277.method_9736(ctx, (String)"fromPos");
        class_243 pos2 = class_2277.method_9736(ctx, (String)"toPos");
        WaypointPersistentState state = WaypointPersistentState.get(src.method_9211());
        Waypoint old = state.getWaypoint(name);
        Waypoint wp = new Waypoint(name, pos1, pos2, old != null ? old.getRadius() : 2.0, particleId != null ? particleId : (old != null ? old.getParticleId() : null), summonId != null ? summonId : (old != null ? old.getSummonEntityId() : null), dy != 0.0 ? dy : (old != null ? old.getSummonDy() : 0.0));
        state.addWaypoint(wp);
        src.method_9226(() -> class_2561.method_43470((String)("\u00a7aWaypoint '" + name + "' saved.")), false);
        return 1;
    }

    private static int executeEditFrom(CommandContext<class_2168> ctx) {
        class_2168 src = (class_2168)ctx.getSource();
        String name = StringArgumentType.getString(ctx, (String)"name");
        class_243 pos = class_2277.method_9736(ctx, (String)"pos");
        Waypoint wp = WaypointCommands.getOrError(src, name);
        if (wp == null) {
            return 0;
        }
        wp.setPos1(pos);
        WaypointCommands.save(src, wp);
        src.method_9226(() -> class_2561.method_43470((String)"\u00a7aUpdated FROM position."), false);
        return 1;
    }

    private static int executeEditTo(CommandContext<class_2168> ctx) {
        class_2168 src = (class_2168)ctx.getSource();
        String name = StringArgumentType.getString(ctx, (String)"name");
        class_243 pos = class_2277.method_9736(ctx, (String)"pos");
        Waypoint wp = WaypointCommands.getOrError(src, name);
        if (wp == null) {
            return 0;
        }
        wp.setPos2(pos);
        WaypointCommands.save(src, wp);
        src.method_9226(() -> class_2561.method_43470((String)"\u00a7aUpdated TO position."), false);
        return 1;
    }

    private static int executeEditRadius(CommandContext<class_2168> ctx) {
        class_2168 src = (class_2168)ctx.getSource();
        String name = StringArgumentType.getString(ctx, (String)"name");
        double r = DoubleArgumentType.getDouble(ctx, (String)"value");
        Waypoint wp = WaypointCommands.getOrError(src, name);
        if (wp == null) {
            return 0;
        }
        wp.setRadius(r);
        WaypointCommands.save(src, wp);
        src.method_9226(() -> class_2561.method_43470((String)("\u00a7aRadius updated to " + r)), false);
        return 1;
    }

    private static int executeEditParticle(CommandContext<class_2168> ctx) {
        class_2168 src = (class_2168)ctx.getSource();
        String name = StringArgumentType.getString(ctx, (String)"name");
        class_2960 id = class_2232.method_9443(ctx, (String)"id");
        Waypoint wp = WaypointCommands.getOrError(src, name);
        if (wp == null) {
            return 0;
        }
        wp.setParticleId(id.toString());
        WaypointCommands.save(src, wp);
        src.method_9226(() -> class_2561.method_43470((String)"\u00a7aUpdated particle."), false);
        return 1;
    }

    private static int executeEditSummon(CommandContext<class_2168> ctx) {
        class_2168 src = (class_2168)ctx.getSource();
        String name = StringArgumentType.getString(ctx, (String)"name");
        class_2960 id = class_2232.method_9443(ctx, (String)"entity");
        double dy = DoubleArgumentType.getDouble(ctx, (String)"dy");
        Waypoint wp = WaypointCommands.getOrError(src, name);
        if (wp == null) {
            return 0;
        }
        wp.setSummonEntityId(id.toString());
        wp.setSummonDy(dy);
        WaypointCommands.save(src, wp);
        src.method_9226(() -> class_2561.method_43470((String)"\u00a7aUpdated summon."), false);
        return 1;
    }

    private static int executeDistance(CommandContext<class_2168> ctx) {
        class_2168 src = (class_2168)ctx.getSource();
        String name = StringArgumentType.getString(ctx, (String)"name");
        double r = DoubleArgumentType.getDouble(ctx, (String)"radius");
        Waypoint wp = WaypointCommands.getOrError(src, name);
        if (wp == null) {
            return 0;
        }
        wp.setRadius(r);
        WaypointCommands.save(src, wp);
        src.method_9226(() -> class_2561.method_43470((String)("\u00a7aRadius set to " + r)), false);
        return 1;
    }

    private static int executeRemove(CommandContext<class_2168> ctx) {
        class_2168 src = (class_2168)ctx.getSource();
        String name = StringArgumentType.getString(ctx, (String)"name");
        WaypointPersistentState state = WaypointPersistentState.get(src.method_9211());
        if (!state.hasWaypoint(name)) {
            src.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cWaypoint not found."));
            return 0;
        }
        state.removeWaypoint(name);
        src.method_9226(() -> class_2561.method_43470((String)("\u00a7aRemoved waypoint '" + name + "'")), false);
        return 1;
    }

    private static int executeList(CommandContext<class_2168> ctx) {
        class_2168 src = (class_2168)ctx.getSource();
        Map<String, Waypoint> map = WaypointPersistentState.get(src.method_9211()).getAllWaypoints();
        if (map.isEmpty()) {
            src.method_9226(() -> class_2561.method_43470((String)"\u00a7eNo waypoints."), false);
            return 1;
        }
        src.method_9226(() -> class_2561.method_43470((String)("\u00a76=== Waypoints (" + map.size() + ") ===")), false);
        map.values().forEach(wp -> src.method_9226(() -> class_2561.method_43470((String)("\u00a7b" + wp.getName() + " \u00a77: " + WaypointCommands.format(wp.getPos1()) + " \u2192 " + WaypointCommands.format(wp.getPos2()) + " \u00a77(r=" + wp.getRadius() + ")" + (String)(wp.getSummonEntityId() != null ? " \u00a7e[summon=" + wp.getSummonEntityId() + "]" : "") + (String)(wp.getParticleId() != null ? " \u00a7a[particle=" + wp.getParticleId() + "]" : ""))), false));
        return 1;
    }

    private static int executeDebugMspt(CommandContext<class_2168> ctx) {
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7d[Debug] Tick Time: \u00a7b" + WaypointTickHandler.lastMspt + " \u00b5s")), false);
        return 1;
    }

    private static int executeDebugActive(CommandContext<class_2168> ctx) {
        class_2168 src = (class_2168)ctx.getSource();
        MinecraftServer server = src.method_9211();
        src.method_9226(() -> class_2561.method_43470((String)"\u00a7b=== Active Waypoints ==="), false);
        Map<String, Waypoint> map = WaypointPersistentState.get(server).getAllWaypoints();
        boolean found = false;
        for (Waypoint wp : map.values()) {
            for (class_3222 player : server.method_3760().method_14571()) {
                double dist = player.method_19538().method_1022(wp.getPos1());
                if (!(dist <= 8.0)) continue;
                found = true;
                src.method_9226(() -> class_2561.method_43470((String)("\u00a7a" + wp.getName() + " \u00a77active (player " + player.method_5477().getString() + ", " + String.format("%.1f", dist) + "m)")), false);
            }
        }
        if (!found) {
            src.method_9226(() -> class_2561.method_43470((String)"\u00a77(no active waypoints)"), false);
        }
        return 1;
    }

    private static Waypoint getOrError(class_2168 src, String name) {
        Waypoint wp = WaypointPersistentState.get(src.method_9211()).getWaypoint(name);
        if (wp == null) {
            src.method_9213((class_2561)class_2561.method_43470((String)("\u00a7cWaypoint '" + name + "' not found.")));
        }
        return wp;
    }

    private static void save(class_2168 src, Waypoint wp) {
        WaypointPersistentState.get(src.method_9211()).addWaypoint(wp);
    }

    private static String format(class_243 v) {
        return String.format("%.1f %.1f %.1f", v.field_1352, v.field_1351, v.field_1350);
    }
}

