/*
 * Decompiled with CFR 0.152.
 */
package net.ppekkungz.waypointwarp.data.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.server.MinecraftServer;
import net.ppekkungz.waypointwarp.data.Waypoint;

public class WaypointPersistentState
extends class_18 {
    private static final String DATA_NAME = "waypointwarp_data";
    private final Map<String, Waypoint> waypoints = new HashMap<String, Waypoint>();

    public static WaypointPersistentState get(MinecraftServer server) {
        class_26 manager = server.method_3847(class_1937.field_25179).method_17983();
        return (WaypointPersistentState)manager.method_17924(WaypointPersistentState::fromNbt, WaypointPersistentState::new, DATA_NAME);
    }

    public static WaypointPersistentState fromNbt(class_2487 nbt) {
        WaypointPersistentState state = new WaypointPersistentState();
        if (!nbt.method_10545("waypoints")) {
            return state;
        }
        class_2487 waypointsNbt = nbt.method_10562("waypoints");
        for (String key : waypointsNbt.method_10541()) {
            class_2487 wpNbt = waypointsNbt.method_10562(key);
            try {
                Waypoint wp = Waypoint.fromNbt(wpNbt);
                state.waypoints.put(wp.getName(), wp);
            }
            catch (Exception e) {
                System.err.println("[WaypointWarpOptimizer] Failed to load waypoint '" + key + "': " + String.valueOf(e));
            }
        }
        return state;
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2487 wrap = new class_2487();
        for (Map.Entry<String, Waypoint> entry : this.waypoints.entrySet()) {
            try {
                wrap.method_10566(entry.getKey(), (class_2520)entry.getValue().toNbt());
            }
            catch (Exception e) {
                System.err.println("[WaypointWarpOptimizer] Failed to save waypoint: " + entry.getKey());
            }
        }
        nbt.method_10566("waypoints", (class_2520)wrap);
        return nbt;
    }

    public void addWaypoint(Waypoint wp) {
        this.waypoints.put(wp.getName(), wp);
        this.method_80();
    }

    public void removeWaypoint(String name) {
        if (this.waypoints.remove(name) != null) {
            this.method_80();
        }
    }

    public Waypoint getWaypoint(String name) {
        return this.waypoints.get(name);
    }

    public boolean hasWaypoint(String name) {
        return this.waypoints.containsKey(name);
    }

    public Map<String, Waypoint> getAllWaypoints() {
        return this.waypoints;
    }

    public Map<String, Waypoint> getAllWaypointsReadOnly() {
        return Collections.unmodifiableMap(this.waypoints);
    }

    public void clear() {
        this.waypoints.clear();
        this.method_80();
    }
}

