/*
 * Decompiled with CFR 0.152.
 */
package net.ppekkungz.waypointwarp.data.tick;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import net.ppekkungz.waypointwarp.data.Waypoint;
import net.ppekkungz.waypointwarp.data.state.WaypointPersistentState;

public class WaypointTickHandler {
    private static final int TELEPORT_COOLDOWN = 20;
    public static final double ACTIVATION_RADIUS = 8.0;
    public static long lastMspt = 0L;
    private static final Map<UUID, Long> lastTeleport = new HashMap<UUID, Long>();

    public static void onServerTick(MinecraftServer server) {
        long start = System.nanoTime();
        WaypointPersistentState state = WaypointPersistentState.get(server);
        Map<String, Waypoint> waypoints = state.getAllWaypoints();
        if (waypoints.isEmpty()) {
            lastMspt = (System.nanoTime() - start) / 1000L;
            return;
        }
        long tick = server.method_3780();
        block0: for (class_3222 player : server.method_3760().method_14571()) {
            UUID pid = player.method_5667();
            Long last = lastTeleport.get(pid);
            if (last != null && tick - last < 20L) continue;
            class_243 playerPos = player.method_19538();
            for (Waypoint wp : waypoints.values()) {
                class_2960 pid2;
                class_1299 type;
                class_1297 entity;
                class_2960 id;
                class_243 pos1 = wp.getPos1();
                class_243 pos2 = wp.getPos2();
                if (playerPos.method_1022(pos1) > 8.0 || !wp.isInRange(playerPos)) continue;
                player.method_20620(pos2.field_1352, pos2.field_1351, pos2.field_1350);
                class_3218 world = player.method_51469();
                if (wp.getSummonEntityId() != null && (id = class_2960.method_12829((String)wp.getSummonEntityId())) != null && class_7923.field_41177.method_10250(id) && (entity = (type = (class_1299)class_7923.field_41177.method_10223(id)).method_5883((class_1937)world)) != null) {
                    entity.method_5808(pos1.field_1352, pos1.field_1351 + wp.getSummonDy(), pos1.field_1350, 0.0f, 0.0f);
                    world.method_8649(entity);
                }
                if (wp.getParticleId() != null && (pid2 = class_2960.method_12829((String)wp.getParticleId())) != null && class_7923.field_41180.method_10250(pid2)) {
                    type = (class_2400)class_7923.field_41180.method_10223(pid2);
                    world.method_14199((class_2394)type, pos1.field_1352, pos1.field_1351 + 1.0, pos1.field_1350, 20, 0.5, 0.5, 0.5, 0.02);
                }
                lastTeleport.put(pid, tick);
                continue block0;
            }
        }
        long end = System.nanoTime();
        lastMspt = (end - start) / 1000L;
    }
}

