package me.rufia.fightorflight.data.movedata.movedatas;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.data.movedata.MoveData;
import me.rufia.fightorflight.effects.FOFEffects;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import java.util.Objects;

public class StatChangeMoveData extends MoveData {
    private int stage;

    public StatChangeMoveData(String target, String triggerEvent, float chance, boolean canActivateSheerForce, String name, int stage) {
        super("stat", target, triggerEvent, chance, canActivateSheerForce, name);
        this.stage = stage;
    }

    private boolean isPositive() {
        return stage > 0 && stage < 7;
    }

    private boolean isNegative() {
        return stage < 0 && stage > -7;
    }

    @Override
    public void invoke(PokemonEntity pokemonEntity, class_1309 target) {
        if (!chanceTest(pokemonEntity.method_59922(), pokemonEntity) || pokemonEntity.getPokemon().getAbility().getName().equals("sheerforce") && canActivateSheerForce()) {
            return;
        }
        class_1309 finalTarget = pickTarget(pokemonEntity, target);
        if (finalTarget == null) {
            return;
        }
        String name = getName();
        //CobblemonFightOrFlight.LOGGER.info("Trying to apply stat related effect");
        if (Objects.equals(name, "attack") || Objects.equals(name, "special_attack")) {
            if (isPositive()) {
                finalTarget.method_6092(new class_1293(class_1294.field_5910, calculateEffectDuration(pokemonEntity) * 20, stage - 1));
            } else if (isNegative()) {
                finalTarget.method_6092(new class_1293(class_1294.field_5911, calculateEffectDuration(pokemonEntity) * 20, -stage - 1));
            }
        } else if (Objects.equals(name, "defense") || Objects.equals(name, "special_defense")) {
            if (isPositive()) {
                finalTarget.method_6092(new class_1293(class_1294.field_5907, calculateEffectDuration(pokemonEntity) * 20, stage - 1));
            } else if (isNegative()) {
                finalTarget.method_6092(new class_1293(FOFEffects.RESISTANCE_WEAKENED, calculateEffectDuration(pokemonEntity) * 20, -stage - 1));//It's not working?
            }
        } else if (Objects.equals(name, "speed")) {
            if (isPositive()) {
                finalTarget.method_6092(new class_1293(class_1294.field_5904, calculateEffectDuration(pokemonEntity) * 20, stage - 1));
            } else if (isNegative()) {
                finalTarget.method_6092(new class_1293(class_1294.field_5909, calculateEffectDuration(pokemonEntity) * 20, -stage - 1));
            }
        } else if (Objects.equals(name, "all")) {
            if (isPositive()) {
                finalTarget.method_6092(new class_1293(class_1294.field_5910, calculateEffectDuration(pokemonEntity) * 20, stage - 1));
                finalTarget.method_6092(new class_1293(class_1294.field_5904, calculateEffectDuration(pokemonEntity) * 20, stage - 1));
                finalTarget.method_6092(new class_1293(class_1294.field_5907, calculateEffectDuration(pokemonEntity) * 20, stage - 1));
            } else if (isNegative()) {
                finalTarget.method_6092(new class_1293(class_1294.field_5909, calculateEffectDuration(pokemonEntity) * 20, -stage - 1));
                finalTarget.method_6092(new class_1293(class_1294.field_5911, calculateEffectDuration(pokemonEntity) * 20, -stage - 1));
                finalTarget.method_6092(new class_1293(FOFEffects.RESISTANCE_WEAKENED, calculateEffectDuration(pokemonEntity) * 20, -stage - 1));
            }
        } else if (Objects.equals(name, "accuracy")) {
            if (isNegative()) {
                finalTarget.method_6092(new class_1293(class_1294.field_5919, calculateEffectDuration(pokemonEntity) * 20, -stage - 1));
            }
        }
    }
}
