package me.rufia.fightorflight.data.movedata.movedatas;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.data.movedata.MoveData;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import java.util.Objects;

public class StatusEffectMoveData extends MoveData {
    public StatusEffectMoveData(String target, String triggerEvent, float chance, boolean canActivateSheerForce, String name) {
        super("status", target, triggerEvent, chance, canActivateSheerForce, name);
    }

    @Override
    public void invoke(PokemonEntity pokemonEntity, class_1309 target) {
        if (!chanceTest(pokemonEntity.method_59922(), pokemonEntity) || pokemonEntity.getPokemon().getAbility().getName().equals("sheerforce") && canActivateSheerForce()) {
            return;
        }
        class_1309 finalTarget = pickTarget(pokemonEntity, target);
        if (finalTarget == null) {
            return;
        }
        int duration = calculateEffectDuration(pokemonEntity);
        if (Objects.equals(getName(), "direclaw")) {
            float f = pokemonEntity.method_59922().method_43057();
            if (f < 0.34) {
                setName("poison");
            } else if (f < 0.67) {
                setName("paralysis");
            } else {
                setName("sleep");
            }
        } else if (Objects.equals(getName(), "triattack")) {
            float f = pokemonEntity.method_59922().method_43057();
            if (f < 0.34) {
                setName("burn");
            } else if (f < 0.67) {
                setName("paralysis");
            } else {
                setName("freeze");
            }
        }
        String name = getName();
        if (Objects.equals(name, "poison")) {
            finalTarget.method_6092(new class_1293(class_1294.field_5899, duration * 30, 0));
        } else if (Objects.equals(name, "badly_poison")) {
            finalTarget.method_6092(new class_1293(class_1294.field_5899, duration * 30, 1));
        } else if (Objects.equals(name, "sleep")) {
            finalTarget.method_6092(new class_1293(class_1294.field_5909, duration * 25, 2));
            finalTarget.method_6092(new class_1293(class_1294.field_5901, duration * 25, 1));
        } else if (Objects.equals(name, "freeze")) {
            finalTarget.method_6092(new class_1293(class_1294.field_5909, duration * 25, 2));
            finalTarget.method_6092(new class_1293(class_1294.field_5901, duration * 25, 1));
            finalTarget.method_32317(finalTarget.method_32312() + duration);
        } else if (Objects.equals(name, "paralysis")) {
            finalTarget.method_6092(new class_1293(class_1294.field_5909, duration * 30, 0));
            finalTarget.method_6092(new class_1293(class_1294.field_5901, duration * 30, 0));
        } else if (Objects.equals(name, "burn")) {
            finalTarget.method_6092(new class_1293(class_1294.field_5911, duration * 30, 0));
            finalTarget.method_20803(duration * 30);
        } else if (Objects.equals(name, "flinch")) {
            finalTarget.method_6092(new class_1293(class_1294.field_5909, 2 * 30, 1));
            finalTarget.method_6092(new class_1293(class_1294.field_5901, 2 * 30, 0));
        } else if (Objects.equals(name, "confusion")) {
            finalTarget.method_6092(new class_1293(class_1294.field_5916, duration * 30, 0));
        }
    }
}
