package me.rufia.fightorflight.entity;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.categories.DamageCategories;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.data.movedata.MoveData;
import me.rufia.fightorflight.entity.areaeffect.AbstractPokemonAreaEffect;
import me.rufia.fightorflight.entity.areaeffect.PokemonTornado;
import me.rufia.fightorflight.entity.projectile.*;
import me.rufia.fightorflight.utils.*;
import me.rufia.fightorflight.utils.explosion.FOFExplosion;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_3483;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import java.awt.*;
import java.util.*;

public class PokemonAttackEffect {
    public static class_2400 getParticleFromType(String name) {
        String nameLower = name.toLowerCase();
        return switch (nameLower) {
            case "fire" -> class_2398.field_11240;
            case "ice" -> class_2398.field_28013;
            case "poison" -> class_2398.field_11219;
            case "psychic" -> class_2398.field_11214;
            case "fairy" -> class_2398.field_43379;
            case "fighting", "ground", "rock" -> class_2398.field_11203;
            case "steel" -> class_2398.field_29643;
            case "ghost" -> class_2398.field_23114;
            case "dark" -> class_2398.field_11251;
            case "electric" -> class_2398.field_29644;
            case "bug" -> class_2398.field_28803;
            case "grass" -> class_2398.field_17741;
            case "dragon" -> class_2398.field_11216;
            case "flying" -> class_2398.field_11227;
            case "water" -> class_2398.field_11202;
            case "normal" -> class_2398.field_11205;
            default -> class_2398.field_11205;
        };
    }

    public static Color getColorFromType(String typeName) {
        String nameLower = typeName.toLowerCase();
        return switch (nameLower) {
            case "fire" -> new Color(230, 40, 41);
            case "ice" -> new Color(63, 216, 255);
            case "poison" -> new Color(145, 65, 203);
            case "psychic" -> new Color(239, 65, 121);
            case "fairy" -> new Color(239, 112, 239);
            case "fighting" -> new Color(255, 128, 0);
            case "steel" -> new Color(96, 161, 184);
            case "ghost" -> new Color(112, 65, 112);
            case "dark" -> new Color(80, 65, 63);
            case "ground" -> new Color(145, 81, 33);
            case "rock" -> new Color(175, 169, 129);
            case "electric" -> new Color(250, 192, 0);
            case "bug" -> new Color(145, 161, 25);
            case "grass" -> new Color(63, 161, 41);
            case "dragon" -> new Color(80, 96, 225);
            case "flying" -> new Color(129, 185, 239);
            case "water" -> new Color(41, 128, 239);
            case "normal" -> new Color(159, 161, 159);
            default -> new Color(68, 104, 94);
        };
    }

    public static class_2400 getParticleFromType(ElementalType type) {
        return getParticleFromType(type.getName());
    }

    public static Color getColorFromType(ElementalType type) {
        return getColorFromType(type.getName());
    }

    public static Color getColorFromType(Pokemon pokemon) {
        return getColorFromType(pokemon.getPrimaryType());
    }

    public static float calculatePokemonDamage(PokemonEntity pokemonEntity, class_1297 target, boolean isSpecial) {
        return calculatePokemonDamage(pokemonEntity, target, isSpecial, (float) CobblemonFightOrFlight.moveConfig().base_power, null);
    }

    public static float calculatePokemonDamage(PokemonEntity pokemonEntity, class_1297 target, boolean isSpecial, float movePower, ElementalType type) {
        int attack = isSpecial ? pokemonEntity.getPokemon().getSpecialAttack() : pokemonEntity.getPokemon().getAttack();
        int maxStat = isSpecial ? CobblemonFightOrFlight.commonConfig().maximum_special_attack_stat : CobblemonFightOrFlight.commonConfig().maximum_attack_stat;
        boolean isUsingRangeAttack = PokemonUtils.shouldShoot(pokemonEntity);
        boolean isUsingMeleeAttack = PokemonUtils.shouldMelee(pokemonEntity);//Status moves might not be any of them in the future?
        PokemonMultipliers multipliers = new PokemonMultipliers(pokemonEntity);
        float attackModifier = CobblemonFightOrFlight.commonConfig().max_bonus_from_stat * class_3532.method_15355((float) Math.min(attack, maxStat) / maxStat);
        float moveModifier = movePower / 40 * CobblemonFightOrFlight.moveConfig().move_power_multiplier;
        float minDmg = isSpecial ? multipliers.getMinimumRangeAttackDamage() : multipliers.getMinimumAttackDamage();
        float maxDmg = isSpecial ? multipliers.getMaximumRangeAttackDamage() : multipliers.getMaximumAttackDamage();
        float sheerForceMultiplier = PokemonUtils.canActivateSheerForce(pokemonEntity) ? 1.3f : 1.0f;
        float multiplier = extraDamageFromEntityFeature(pokemonEntity, target, type) * getHeldItemDmgMultiplier(pokemonEntity, target) * sheerForceMultiplier * multipliers.getPlayerOwnedDamageMultiplier(isUsingRangeAttack, isUsingMeleeAttack);
        float mobEffectBoost = getMobEffectBoost(pokemonEntity);
        PokemonInterface pokemonInterface = ((PokemonInterface) pokemonEntity);
        if (pokemonInterface.usingBeam() || pokemonInterface.usingSound() || pokemonInterface.usingMagic()) {
            multiplier *= CobblemonFightOrFlight.moveConfig().indirect_attack_move_power_multiplier;
        }
        float value = Math.min(Math.max(multiplier * (moveModifier * attackModifier + mobEffectBoost), minDmg), maxDmg);
        //CobblemonFightOrFlight.LOGGER.info("value:{} minDmg:{} maxDmg:{} attack:{} attackModifier:{} moveModifier:{} multiplier:{}", value, minDmg, maxDmg, attack, attackModifier, moveModifier, multiplier);
        return value;
    }

    public static float calculatePokemonDamage(PokemonEntity pokemonEntity, class_1297 target, Move move) {
        //TODO Special effect for Photon Geyser
        if (move == null) {
            CobblemonFightOrFlight.LOGGER.info("Null move detected");
            return CobblemonFightOrFlight.commonConfig().minimum_ranged_attack_damage;
        }
        if (PokemonUtils.isStatusMove(move)) {
            return 0f;
        }
        boolean isSpecial = PokemonUtils.isSpecialMove(move);
        float STAB;
        var primaryType = pokemonEntity.getPokemon().getPrimaryType();
        var secondaryType = pokemonEntity.getPokemon().getSecondaryType();
        if (secondaryType == null) {
            secondaryType = primaryType;
        }
        if (primaryType.equals(move.getType()) || secondaryType.equals(move.getType())) {
            STAB = PokemonUtils.abilityIs(pokemonEntity, "adaptability") ? 2f : 1.5f;
        } else {
            STAB = 1.0f;
        }
        return calculatePokemonDamage(pokemonEntity, target, isSpecial, (float) (move.getPower() * STAB), move.getType());
    }

    protected static float extraDamageFromEntityFeature(PokemonEntity pokemonEntity, class_1297 target, ElementalType moveType) {
        if (target.method_37908().field_9236 || !(target instanceof class_1309 livingEntity)) {
            return 1.0f;
        }
        ElementalType type = moveType == null ? pokemonEntity.getPokemon().getPrimaryType() : moveType;
        if (!(livingEntity instanceof PokemonEntity targetPokemon)) {
            if (ElementalTypes.INSTANCE.getWATER().equals(type)) {
                if (livingEntity.method_29503()) {
                    return CobblemonFightOrFlight.commonConfig().water_type_super_effective_dmg_multiplier;
                }
            }
            if (ElementalTypes.INSTANCE.getFIRE().equals(type)) {
                if (livingEntity.method_5753()) {
                    return CobblemonFightOrFlight.commonConfig().fire_type_no_effect_dmg_multiplier;
                }
            }
            if (ElementalTypes.INSTANCE.getICE().equals(type)) {
                if (!livingEntity.method_32316()) {
                    return CobblemonFightOrFlight.commonConfig().ice_type_no_effect_dmg_multiplier;
                }
                if (livingEntity.method_5864().method_20210(class_3483.field_29826)) {
                    return CobblemonFightOrFlight.commonConfig().ice_type_super_effective_dmg_multiplier;
                }
            }
            if (ElementalTypes.INSTANCE.getPOISON().equals(type)) {
                if (livingEntity.method_5864().method_20210(class_3483.field_46232)) {

                    return CobblemonFightOrFlight.commonConfig().poison_type_no_effect_dmg_multiplier;
                }
            }
        } else {
            //TODO type effectiveness here
            return TypeEffectiveness.getTypeEffectiveness(pokemonEntity, targetPokemon);
        }
        return 1.0f;
    }

    public static int getMobEffectBoost(PokemonEntity pokemonEntity) {
        int strengthLevel = 0;
        int weaknessLevel = 0;
        if (pokemonEntity.method_6059(class_1294.field_5910)) {
            var strengthEffect = pokemonEntity.method_6112(class_1294.field_5910);
            if (strengthEffect != null) {
                strengthLevel = strengthEffect.method_5578() + 1;
            }
        }
        if (pokemonEntity.method_6059(class_1294.field_5911)) {
            var weaknessEffect = pokemonEntity.method_6112(class_1294.field_5911);
            if (weaknessEffect != null) {
                weaknessLevel = weaknessEffect.method_5578() + 1;
            }
        }
        return strengthLevel * 3 - weaknessLevel * 4;
    }

    public static float getHeldItemDmgMultiplier(PokemonEntity pokemonEntity, class_1297 target) {
        if (!FOFHeldItemManager.canUseHeldItemDamageInfluencing()) {
            return 1f;
        }
        class_1799 heldItem = PokemonUtils.getHeldItem(pokemonEntity);
        Move move = PokemonUtils.getMove(pokemonEntity);
        ElementalType type = null;
        if (move != null) {
            type = move.getType();
        }

        if (heldItem.method_31574(CobblemonItems.LIFE_ORB)) {
            return 1.3f;//Do you really like 5324/4096(1.2998046875)?
        }
        if (move != null) {
            if (DamageCategories.INSTANCE.getPHYSICAL().equals(move.getDamageCategory())) {
                if (heldItem.method_31574(CobblemonItems.MUSCLE_BAND)) {
                    return 1.1f;
                } else if (heldItem.method_31574(CobblemonItems.CHOICE_BAND)) {
                    return 1.5f;
                }
            } else if (DamageCategories.INSTANCE.getSPECIAL().equals(move.getDamageCategory())) {
                if (heldItem.method_31574(CobblemonItems.WISE_GLASSES)) {
                    return 1.1f;
                } else if (heldItem.method_31574(CobblemonItems.CHOICE_SPECS)) {
                    return 1.5f;
                }
            }
        }
        //Type-enhancing item.
        if (type != null) {
            float typeEnhancingMultiplier = 1.2f;
            String typeName = type.getName().toLowerCase();
            switch (typeName) {
                case "fire":
                    if (heldItem.method_31574(CobblemonItems.CHARCOAL)) return typeEnhancingMultiplier;
                    break;
                case "ice":
                    if (heldItem.method_31574(CobblemonItems.NEVER_MELT_ICE)) return typeEnhancingMultiplier;
                    break;
                case "poison":
                    if (heldItem.method_31574(CobblemonItems.POISON_BARB)) return typeEnhancingMultiplier;
                    break;
                case "psychic":
                    if (heldItem.method_31574(CobblemonItems.TWISTED_SPOON)) return typeEnhancingMultiplier;
                    break;
                case "fairy":
                    if (heldItem.method_31574(CobblemonItems.FAIRY_FEATHER)) return typeEnhancingMultiplier;
                    break;
                case "fighting":
                    if (heldItem.method_31574(CobblemonItems.BLACK_BELT)) return typeEnhancingMultiplier;
                    break;
                case "steel":
                    if (heldItem.method_31574(CobblemonItems.METAL_COAT)) return typeEnhancingMultiplier;
                    break;
                case "ghost":
                    if (heldItem.method_31574(CobblemonItems.SPELL_TAG)) return typeEnhancingMultiplier;
                    break;
                case "dark":
                    if (heldItem.method_31574(CobblemonItems.BLACK_GLASSES)) return typeEnhancingMultiplier;
                    break;
                case "ground":
                    if (heldItem.method_31574(CobblemonItems.SOFT_SAND)) return typeEnhancingMultiplier;
                    break;
                case "rock":
                    if (heldItem.method_31574(CobblemonItems.HARD_STONE)) return typeEnhancingMultiplier;
                    break;
                case "electric":
                    if (heldItem.method_31574(CobblemonItems.MAGNET)) return typeEnhancingMultiplier;
                    break;
                case "bug":
                    if (heldItem.method_31574(CobblemonItems.SILVER_POWDER)) return typeEnhancingMultiplier;
                    break;
                case "grass":
                    if (heldItem.method_31574(CobblemonItems.MIRACLE_SEED)) return typeEnhancingMultiplier;
                    break;
                case "dragon":
                    if (heldItem.method_31574(CobblemonItems.DRAGON_FANG)) return typeEnhancingMultiplier;
                    break;
                case "flying":
                    if (heldItem.method_31574(CobblemonItems.SHARP_BEAK)) return typeEnhancingMultiplier;
                    break;
                case "water":
                    if (heldItem.method_31574(CobblemonItems.MYSTIC_WATER)) return typeEnhancingMultiplier;
                    break;
                case "normal":
                    if (heldItem.method_31574(CobblemonItems.SILK_SCARF)) return typeEnhancingMultiplier;
                    break;
                default:
                    break;
            }
        }
        return 1.0f;
    }

    public static boolean canChangeMove(PokemonEntity pokemonEntity) {
        class_1799 itemStack = PokemonUtils.getHeldItem(pokemonEntity);
        return !itemStack.method_31574(CobblemonItems.CHOICE_BAND) && !itemStack.method_31574(CobblemonItems.CHOICE_SCARF) && !itemStack.method_31574(CobblemonItems.CHOICE_SPECS);
    }

    protected static void calculateTypeEffect(PokemonEntity pokemonEntity, class_1297 hurtTarget, String typeName, int pkmLevel) {
        if (PokemonUtils.isSheerForce(pokemonEntity)) {
            return;
        }
        if (hurtTarget instanceof
                class_1309 livingHurtTarget) {
            int effectStrength = Math.max(pkmLevel / 10, 1);
            String type = typeName.toLowerCase();
            switch (type) {
                case "fire":
                    livingHurtTarget.method_20803(effectStrength * 20);
                    break;
                case "ice":
                    livingHurtTarget.method_32317(livingHurtTarget.method_32312() + effectStrength * 30);
                    break;
                case "poison":
                    livingHurtTarget.method_37222(new class_1293(class_1294.field_5899, effectStrength * 20, 0), pokemonEntity);
                    break;
                case "psychic":
                    livingHurtTarget.method_37222(new class_1293(class_1294.field_5902, effectStrength * 20, 0), pokemonEntity);
                    break;
                case "fairy":
                case "fighting":
                case "steel":
                    livingHurtTarget.method_37222(new class_1293(class_1294.field_5911, effectStrength * 20, 0), pokemonEntity);
                    break;
                case "ghost":
                case "dark":
                    livingHurtTarget.method_37222(new class_1293(class_1294.field_38092, effectStrength * 25, 0), pokemonEntity);
                    break;
                case "ground":
                case "rock":
                    livingHurtTarget.method_37222(new class_1293(class_1294.field_5901, effectStrength * 25, 0), pokemonEntity);
                    break;
                case "electric":
                    livingHurtTarget.method_37222(new class_1293(class_1294.field_5909, effectStrength * 25, 0), pokemonEntity);
                    break;
                case "bug":
                    livingHurtTarget.method_37222(new class_1293(class_1294.field_5903, effectStrength * 25, 0), pokemonEntity);
                    break;
                case "grass":
                    pokemonEntity.method_37222(new class_1293(class_1294.field_5924, effectStrength * 40, 0), pokemonEntity);
                    break;
                case "water":
                    livingHurtTarget.method_37222(new class_1293(class_1294.field_5909, (effectStrength + 2) * 25, 0), pokemonEntity);
                    break;
                case "dragon", "flying":
                default:
                    break;
            }
        }
    }

    public static void applyTypeEffect(PokemonEntity pokemonEntity, class_1297 hurtTarget, String typeName) {
        if (pokemonEntity == null) {
            return;
        }
        Pokemon pokemon = pokemonEntity.getPokemon();
        int pkmLevel = pokemon.getLevel();

        calculateTypeEffect(pokemonEntity, hurtTarget, typeName, pkmLevel);
    }

    public static void applyTypeEffect(PokemonEntity pokemonEntity, class_1297 hurtTarget) {
        if (pokemonEntity == null) {
            return;
        }
        Pokemon pokemon = pokemonEntity.getPokemon();
        int pkmLevel = pokemon.getLevel();
        String primaryType = pokemon.getPrimaryType().getName();
        calculateTypeEffect(pokemonEntity, hurtTarget, primaryType, pkmLevel);
    }

    public static void applyOnHitVisualEffect(PokemonEntity pokemonEntity, class_1297 hurtTarget, Move move) {
        if (move == null) {
            return;
        }
        String moveName = move.getName();
        applyOnHitVisualEffect(pokemonEntity, hurtTarget, moveName);
    }

    public static void applyOnHitVisualEffect(PokemonEntity pokemonEntity, class_1297 hurtTarget, String moveName) {
        int particleAmount = 4;
        boolean b1 = Arrays.stream(CobblemonFightOrFlight.visualEffectConfig().self_angry_moves).toList().contains(moveName);
        boolean b2 = Arrays.stream(CobblemonFightOrFlight.visualEffectConfig().target_soul_fire_moves).toList().contains(moveName);
        boolean b3 = Arrays.stream(CobblemonFightOrFlight.visualEffectConfig().target_soul_moves).toList().contains(moveName);
        boolean b4 = Arrays.stream(CobblemonFightOrFlight.visualEffectConfig().slicing_moves).toList().contains(moveName);
        boolean b5 = Arrays.stream(CobblemonFightOrFlight.moveConfig().magic_attack_moves).toList().contains(moveName);
        if (b1) {
            PokemonUtils.makeParticle(particleAmount, pokemonEntity, class_2398.field_11231);
        }
        if (b2) {
            PokemonUtils.makeParticle(particleAmount, hurtTarget, class_2398.field_22246);
        }
        if (b3) {
            PokemonUtils.makeParticle(particleAmount, hurtTarget, class_2398.field_23114);
        }
        if (b4) {
            PokemonUtils.makeParticle(particleAmount, hurtTarget, class_2398.field_11227);
        }
        if (b5) {
            makeMagicAttackParticle(pokemonEntity, hurtTarget);
        }
        if (hurtTarget instanceof PokemonEntity targetPokemon) {
            float typeEffectivenessMultiplier = TypeEffectiveness.getTypeEffectiveness(pokemonEntity, targetPokemon);
            if (typeEffectivenessMultiplier >= 1.3f) {
                //Filter/Solid Rock will reduce the damage,1.3 is to avoid the inaccuracy of float.
                PokemonUtils.makeParticle(particleAmount, hurtTarget, class_2398.field_29642);
            } else if (typeEffectivenessMultiplier < 1f) {
                PokemonUtils.makeParticle(particleAmount, hurtTarget, class_2398.field_29645);
            }
        }
    }

    public static void makeMagicAttackParticle(PokemonEntity pokemonEntity, class_1297 target) {
        int particleAmount = 8;
        Move move = PokemonUtils.getRangeAttackMove(pokemonEntity);
        if (move == null) {
            return;
        }
        makeTypeEffectParticle(particleAmount, pokemonEntity, move.getType().getName());
        makeTypeEffectParticle(particleAmount, target, move.getType().getName());
    }

    public static void makeTypeEffectParticle(int particleAmount, class_1297 entity, String typeName) {
        if (typeName == null) {
            return;
        }
        PokemonUtils.makeParticle(particleAmount, entity, getParticleFromType(typeName));
    }

    public static void applyOnUseEffect(PokemonEntity pokemonEntity, class_1309 hurtTarget, Move move) {
        class_1937 level = hurtTarget.method_37908();
        if (move == null || level.field_9236) {
            return;
        }
        if (CobblemonFightOrFlight.commonConfig().activate_move_effect) {
            if (MoveData.moveData.containsKey(move.getName())) {
                for (MoveData data : MoveData.moveData.get(move.getName())) {
                    if (data.isOnUse()) {
                        data.invoke(pokemonEntity, hurtTarget);
                    }
                }
            }
        }
    }

    public static void applyPostEffect(PokemonEntity pokemonEntity, class_1309 hurtTarget, Move move, boolean targetIsHurt) {
        class_1937 level = hurtTarget.method_37908();
        if (move == null || level.field_9236) {
            return;
        }
        String moveName = move.getName();
        //These effects might stack, so a chain of ifs might be needed.
        boolean b1 = Arrays.stream(CobblemonFightOrFlight.moveConfig().switch_moves).toList().contains(moveName);
        boolean b2 = Arrays.stream(CobblemonFightOrFlight.moveConfig().explosive_moves).toList().contains(moveName);
        boolean b3 = Arrays.stream(CobblemonFightOrFlight.moveConfig().recoil_moves_allHP).toList().contains(moveName);
        boolean b4 = Arrays.stream(CobblemonFightOrFlight.moveConfig().hp_draining_moves_50).toList().contains(moveName);
        boolean b5 = Arrays.stream(CobblemonFightOrFlight.moveConfig().hp_draining_moves_75).toList().contains(moveName);
        boolean b6 = FOFHeldItemManager.canUse(pokemonEntity, CobblemonItems.LIFE_ORB);
        float dmg = calculatePokemonDamage(pokemonEntity, hurtTarget, move);
        if (b1) {
            pokemonRecallWithAnimation(pokemonEntity);
        }
        if (b2) {
            pokemonExplode(pokemonEntity, level);
        }
        if (b3) {
            pokemonRecoilSelf(pokemonEntity, 1.0f);
        }

        if (b4 || b5) {
            boolean hasBigRoot = FOFHeldItemManager.canUse(pokemonEntity, CobblemonItems.BIG_ROOT);
            float percent = (b4 ? 0.5f : 0.75f) * (hasBigRoot ? 1.3f : 1.0f);
            pokemonEntity.method_6025(dmg * percent);
        }

        if (b6) {
            var abilityName = pokemonEntity.getPokemon().getAbility().getName();
            if (!(abilityName.equals("sheerforce") || abilityName.equals("magicguard"))) {
                pokemonRecoilSelf(pokemonEntity, 0.1f);
            }
        }

        if (CobblemonFightOrFlight.commonConfig().activate_type_effect) {
            applyTypeEffect(pokemonEntity, hurtTarget, move.getType().getName());
        }

        if (CobblemonFightOrFlight.commonConfig().activate_move_effect) {
            if (MoveData.moveData.containsKey(move.getName())) {
                for (MoveData data : MoveData.moveData.get(move.getName())) {
                    if (data.isOnHit() && targetIsHurt) {
                        data.invoke(pokemonEntity, hurtTarget);
                    }
                }
            }
        }

        if (!PokemonUtils.isSheerForce(pokemonEntity)) {
            if (FOFHeldItemManager.canUse(pokemonEntity, CobblemonItems.SHELL_BELL)) {
                float healAmount = dmg / 8;
                pokemonEntity.method_6025(healAmount > 1 ? healAmount : 1);
            }
        }
    }

    public static void pokemonRecallWithAnimation(PokemonEntity pokemonEntity) {
        if (pokemonEntity.method_35057() != null) {
            pokemonEntity.recallWithAnimation();
        }
    }

    protected static void addProjectileEntity(PokemonEntity pokemonEntity, class_1309 target, AbstractPokemonProjectile projectile, Move move) {
        projectile.setElementalType(move.getType().getName());
        projectile.setDamage(calculatePokemonDamage(pokemonEntity, target, move));
        pokemonEntity.method_37908().method_8649(projectile);
    }

    protected static void addProjectileEntity(PokemonEntity pokemonEntity, class_1309 target, AbstractPokemonProjectile projectile) {
        projectile.setElementalType(pokemonEntity.getPokemon().getPrimaryType().getName());
        projectile.setDamage(calculatePokemonDamage(pokemonEntity, target, true));
        pokemonEntity.method_37908().method_8649(projectile);
    }

    protected static void shootProjectileEntity(PokemonEntity pokemonEntity, class_1309 target, AbstractPokemonProjectile projectile) {
        double d = target.method_23317() - pokemonEntity.method_23317();
        double e = target.method_23323(0.5) - projectile.method_23318();
        double f = target.method_23321() - pokemonEntity.method_23321();
        float velocity = 1.6f;
        projectile.accurateShoot(d, e, f, velocity, 0.1f);
    }

    public static void pokemonPerformRangedAttack(PokemonEntity pokemonEntity, class_1309 target) {
        if (pokemonEntity == null || target == null) {
            return;
        }
        Move move = PokemonUtils.getRangeAttackMove(pokemonEntity);
        AbstractPokemonProjectile bullet;
        PokemonUtils.sendAnimationPacket(pokemonEntity, "special");
        if (move != null) {
            String moveName = move.getName();
            Random rand = new Random();
            boolean b1 = Arrays.stream(CobblemonFightOrFlight.moveConfig().single_bullet_moves).toList().contains(moveName);
            boolean b2 = Arrays.stream(CobblemonFightOrFlight.moveConfig().multiple_bullet_moves).toList().contains(moveName);
            boolean b3 = Arrays.stream(CobblemonFightOrFlight.moveConfig().single_tracing_bullet_moves).toList().contains(moveName);
            boolean b4 = Arrays.stream(CobblemonFightOrFlight.moveConfig().multiple_tracing_bullet_moves).toList().contains(moveName);
            boolean b5 = Arrays.stream(CobblemonFightOrFlight.moveConfig().single_beam_moves).toList().contains(moveName);
            boolean b6 = PokemonUtils.isExplosiveMove(moveName);
            boolean b7 = Arrays.stream(CobblemonFightOrFlight.moveConfig().sound_based_moves).toList().contains(moveName);
            boolean b8 = Arrays.stream(CobblemonFightOrFlight.moveConfig().magic_attack_moves).toList().contains(moveName);
            boolean b9 = Arrays.stream(CobblemonFightOrFlight.moveConfig().delayed_aoe_at_target_position).toList().contains(moveName);
            if (b3 || b4) {
                for (int i = 0; i < (b3 ? 1 : rand.nextInt(3) + 1); ++i) {
                    bullet = new PokemonTracingBullet(pokemonEntity.method_37908(), pokemonEntity, target, pokemonEntity.method_5735().method_10166());
                    addProjectileEntity(pokemonEntity, target, bullet, move);
                }
            } else if (b1 || b2) {
                for (int i = 0; i < (b1 ? 1 : rand.nextInt(3) + 1); ++i) {
                    bullet = new PokemonBullet(pokemonEntity.method_37908(), pokemonEntity);
                    shootProjectileEntity(pokemonEntity, target, bullet);
                    addProjectileEntity(pokemonEntity, target, bullet, move);
                }
            } else if (b5 || b7 || b8) {
                if (!PokemonUtils.pokemonTryForceEncounter(pokemonEntity, target)) {
                    boolean success = target.method_5643(pokemonEntity.method_48923().method_48815(pokemonEntity, pokemonEntity), calculatePokemonDamage(pokemonEntity, target, move));
                    PokemonUtils.setHurtByPlayer(pokemonEntity, target);
                    applyOnHitVisualEffect(pokemonEntity, target, move);
                    applyPostEffect(pokemonEntity, target, move, success);
                }
                //applyTypeEffect(pokemonEntity, target);
            } else if (b6) {
                //Should not be processed here.
            } else if (b9) {
                createAOE(pokemonEntity, target, move);
            } else {
                bullet = new PokemonArrow(pokemonEntity.method_37908(), pokemonEntity, target);
                shootProjectileEntity(pokemonEntity, target, bullet);
                addProjectileEntity(pokemonEntity, target, bullet, move);
            }
            if (CobblemonFightOrFlight.commonConfig().activate_move_effect) {
                applyOnUseEffect(pokemonEntity, target, move);
            }
        } else {
            bullet = new PokemonArrow(pokemonEntity.method_37908(), pokemonEntity, target);
            shootProjectileEntity(pokemonEntity, target, bullet);
            addProjectileEntity(pokemonEntity, target, bullet);
        }
    }

    public static void createAOE(PokemonEntity pokemonEntity, class_1309 target, Move move) {
        if (move == null) {
            return;
        }
        var aoe = AbstractPokemonAreaEffect.tryToCreate(pokemonEntity, target, move);
        if (aoe != null) {
            aoe.setElementalType(move.getType().getName());
            pokemonEntity.method_37908().method_8649(aoe);
        }
    }

    public static void spreadSpikes(PokemonEntity pokemonEntity, String type) {
        if (pokemonEntity == null || type == null || !CobblemonFightOrFlight.moveConfig().enable_spikes) {
            return;
        }

        class_5819 rand = pokemonEntity.method_37908().field_9229;
        int count = rand.method_39332(6, 8);
        double horizontal = 1 + pokemonEntity.method_17681() / 2;
        float velocity = 0.8f;

        if (PokemonUtils.getTarget(pokemonEntity) instanceof class_1309 target) {
            double x = target.method_23317() - pokemonEntity.method_23317();
            double z = target.method_23321() - pokemonEntity.method_23321();
            spreadFanShape(x, z, count, 3, pokemonEntity, type, rand, velocity);
        } else {
            spreadAround(horizontal, count, pokemonEntity, type, rand, velocity);
        }
    }

    protected static void spreadFanShape(double xf, double zf, int count, int level, PokemonEntity pokemonEntity, String type, class_5819 rand, float velocity) {
        float length = class_3532.method_15355((float) (xf * xf + zf * zf));
        if (level > count) {
            level = 1;
        }
        List<Integer> lis = new ArrayList<>();
        int tmp = count;
        for (int i = 0; i < level - 1; ++i) {
            int max = count / level;
            int n = rand.method_39332(1, max);
            lis.add(n);
            tmp -= n;
        }
        lis.add(tmp);
        for (int n = 0; n < level; ++n) {
            for (int i = 0; i < lis.get(n); ++i) {
                float mul = (1f + n) / length;
                float rad = FOFUtils.toRad(45f * (rand.method_43057() - 0.5));
                AbstractPokemonSpike spike = createSpike(pokemonEntity.method_37908(), pokemonEntity, type);
                //CobblemonFightOrFlight.LOGGER.info("{}-{}", spike.getBlockY(), spike.getY());
                spike.accurateShoot(mul * (xf * class_3532.method_15362(rad) - zf * class_3532.method_15374(rad)), 0, mul * (xf * class_3532.method_15374(rad) + zf * class_3532.method_15362(rad)), velocity, 0.1f);

                pokemonEntity.method_37908().method_8649(spike);
            }
        }
    }

    protected static void spreadAround(double r, int count, PokemonEntity pokemonEntity, String type, class_5819 rand, float velocity) {
        for (int i = 0; i < count; ++i) {
            AbstractPokemonSpike spike = createSpike(pokemonEntity.method_37908(), pokemonEntity, type);
            if (spike == null) {
                return;
            }
            float rad = FOFUtils.toRad(360f / count * (i + (rand.method_43057() - 0.5) / 2));
            spike.accurateShoot(r * class_3532.method_15362(rad), 0, r * class_3532.method_15374(rad), velocity, 0.1f);
            pokemonEntity.method_37908().method_8649(spike);
        }
    }

    protected static AbstractPokemonSpike createSpike(class_1937 level, class_1309 shooter, String type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case "spikes" -> {
                PokemonSpike spike = new PokemonSpike(level, shooter);
                spike.setElementalType("ground");
                return spike;
            }
            case "toxic_spikes" -> {
                PokemonSpike spike = new PokemonSpike(level, shooter);
                spike.setElementalType("poison");
                return spike;
            }
            case "stealth_rock" -> {
                PokemonFloatingSpike spike = new PokemonFloatingSpike(level, shooter);
                spike.setElementalType("rock");
                return spike;
            }
            case "sticky_web" -> {
                PokemonStickyWeb spike = new PokemonStickyWeb(level, shooter);
                spike.setElementalType("bug");
                return spike;
            }
        }
        return null;
    }

    public static void pokemonExplode(PokemonEntity entity, class_1937 level) {
        if (!level.field_9236) {
            FOFExplosion explosion = FOFExplosion.createExplosion(entity, entity, entity.method_23317(), entity.method_23318(), entity.method_23321(), true, false);
            if (explosion != null) {
                explosion.method_8348();
                explosion.finalizeExplosion();
            } else {
                CobblemonFightOrFlight.LOGGER.warn("Failed to create the explosion");
            }
        }
    }

    public static void dealAoEDamage(PokemonEntity pokemonEntity, class_1297 centerEntity, boolean shouldHurtAlly, boolean decreaseOverDistance, boolean hasDirectContact) {
        if (pokemonEntity == null) {
            return;
        }
        Move move = PokemonUtils.getMove(pokemonEntity);
        if (move == null) {
            CobblemonFightOrFlight.LOGGER.warn("No move for aoe.");
            return;
        }
        double radius = getAoERadius(pokemonEntity, move);
        //CobblemonFightOrFlight.LOGGER.info(Double.toString(radius));
        List<class_1309> list = centerEntity.method_37908().method_18467(class_1309.class, centerEntity.method_5829().method_1014(radius - centerEntity.method_17681() / 2));
        Iterator<class_1309> it = list.iterator();
        while (true) {
            class_1309 livingEntity;
            do {
                if (!it.hasNext()) {
                    return;
                }
                livingEntity = it.next();
            } while (centerEntity.method_5858(livingEntity) > 25.0);
            if (livingEntity == pokemonEntity || !(shouldHurtAlly && shouldHurtAllyMob(pokemonEntity, livingEntity))) {
                continue;
            }
            float dmgMultiplier;
            if (decreaseOverDistance) {
                float distance = centerEntity.method_5739(livingEntity);
                if (distance < CobblemonFightOrFlight.moveConfig().min_AoE_radius) {
                    dmgMultiplier = 1.0f;
                } else {
                    //TODO unfinished
                    dmgMultiplier = CobblemonFightOrFlight.moveConfig().min_AoE_damage_multiplier;//Will be replaced when I have enough free time
                }

            } else {
                dmgMultiplier = CobblemonFightOrFlight.moveConfig().min_AoE_damage_multiplier;
            }
            var dmgSource = hasDirectContact ? centerEntity.method_48923().method_48812(pokemonEntity) : centerEntity.method_48923().method_48815(pokemonEntity, pokemonEntity);
            boolean bl = livingEntity.method_5643(dmgSource, calculatePokemonDamage(pokemonEntity, livingEntity, move) * dmgMultiplier);
            if (bl) {
                PokemonUtils.setHurtByPlayer(pokemonEntity, livingEntity);
                applyOnHitVisualEffect(pokemonEntity, livingEntity, move);
                makeTypeEffectParticle(10, livingEntity, move.getType().getName());
            }
        }
    }

    public static void dealAoEDamage(PokemonEntity pokemonEntity, class_1297 centerEntity, boolean shouldHurtAlly, boolean hasDirectContact) {
        if (pokemonEntity != null) {
            Move move = PokemonUtils.getMove(pokemonEntity);
            if (move != null) {
                dealAoEDamage(pokemonEntity, centerEntity, shouldHurtAlly, true, hasDirectContact);
            } else {
                CobblemonFightOrFlight.LOGGER.warn("[FOF]:Failed to get move for aoe damage");
            }
        }
    }

    public static void pokemonRecoilSelf(PokemonEntity pokemonEntity, float percent) {
        Pokemon pokemon = pokemonEntity.getPokemon();
        float curHealth = pokemonEntity.method_6032();
        float maxHealth = pokemonEntity.method_6063();
        float health = curHealth - maxHealth * percent;
        if (health > 0) {
            pokemonEntity.method_6033(curHealth);
        } else {
            pokemonEntity.method_6033(0);
        }
        PokemonUtils.entityHpToPokemonHp(pokemonEntity, maxHealth * percent, false);
        if (pokemonEntity.method_6032() == 0f) {
            pokemon.setCurrentHealth(0);
        }
    }

    public static float getAoERadius(PokemonEntity entity, Move move) {
        Pokemon pokemon = entity.getPokemon();
        boolean isSpecial = move.getDamageCategory().equals(DamageCategories.INSTANCE.getSPECIAL());
        int stat = isSpecial ? pokemon.getSpecialAttack() : pokemon.getAttack();
        int requiredStat = isSpecial ? CobblemonFightOrFlight.commonConfig().maximum_special_attack_stat : CobblemonFightOrFlight.commonConfig().maximum_attack_stat;
        return Math.min(class_3532.method_16439(((float) stat) / requiredStat, CobblemonFightOrFlight.moveConfig().min_AoE_radius, CobblemonFightOrFlight.moveConfig().max_AoE_radius), CobblemonFightOrFlight.moveConfig().max_AoE_radius);
    }

    public static int calculateAttackTime(PokemonEntity pokemonEntity, double distance) {
        if (pokemonEntity == null) {
            return -1;
        }
        boolean isMelee = PokemonUtils.shouldMelee(pokemonEntity);
        float attackSpeedModifier = Math.max(0.1f, 1 - pokemonEntity.method_6029() / CobblemonFightOrFlight.commonConfig().speed_stat_limit);
        float f = (isMelee ? 0.2f : (float) Math.sqrt(distance) / PokemonUtils.getAttackRadius()) * attackSpeedModifier;
        if (isMelee) {
            return class_3532.method_15375(20 * class_3532.method_16439(f, CobblemonFightOrFlight.commonConfig().minimum_melee_attack_interval, CobblemonFightOrFlight.commonConfig().maximum_melee_attack_interval));
        } else {
            return class_3532.method_15375(20 * class_3532.method_16439(f, CobblemonFightOrFlight.commonConfig().minimum_ranged_attack_interval, CobblemonFightOrFlight.commonConfig().maximum_ranged_attack_interval));
        }
    }

    public static void refreshAttackTime(PokemonEntity pokemonEntity, int attackTime) {
        ((PokemonInterface) pokemonEntity).setAttackTime(attackTime);
        ((PokemonInterface) pokemonEntity).setMaxAttackTime(attackTime);
    }

    public static void resetAttackTime(PokemonEntity pokemonEntity, double distance) {
        int attackTime = calculateAttackTime(pokemonEntity, distance);
        refreshAttackTime(pokemonEntity, attackTime);
    }

    public static boolean pokemonAttack(PokemonEntity pokemonEntity, class_1297 hurtTarget) {
        Pokemon pokemon = pokemonEntity.getPokemon();
        float hurtDamage;
        float hurtKnockback = 1f;
        Move move = PokemonUtils.getMeleeMove(pokemonEntity);
        if (move != null) {
            boolean b1 = PokemonUtils.isExplosiveMove(move.getName());
            if (b1) {
                hurtDamage = 0f;
            } else {
                hurtDamage = calculatePokemonDamage(pokemonEntity, hurtTarget, move);
            }
            if (hurtTarget instanceof class_1309 livingEntity) {
                makeTypeEffectParticle(10, livingEntity, move.getType().getName());
                PokemonUtils.updateMoveEvolutionProgress(pokemon, move.getTemplate());
                if (CobblemonFightOrFlight.commonConfig().activate_move_effect) {
                    applyOnUseEffect(pokemonEntity, livingEntity, move);
                }
            }
        } else {
            if (CobblemonFightOrFlight.commonConfig().activate_type_effect) {
                applyTypeEffect(pokemonEntity, hurtTarget);
            }
            makeTypeEffectParticle(6, hurtTarget, pokemonEntity.getPokemon().getPrimaryType().getName());
            hurtDamage = calculatePokemonDamage(pokemonEntity, hurtTarget, false);
        }
        applyOnHitVisualEffect(pokemonEntity, hurtTarget, move);
        PokemonUtils.setHurtByPlayer(pokemonEntity, hurtTarget);

        boolean flag = hurtTarget.method_5643(pokemonEntity.method_37908().method_48963().method_48812(pokemonEntity), hurtDamage);
        if (flag) {
            if (hurtTarget instanceof class_1309 livingEntity) {
                if (CobblemonFightOrFlight.commonConfig().activate_type_effect) {
                    pokemonEntity.method_18799(pokemonEntity.method_18798().method_18805(0.6D, 1.0D, 0.6D));
                }
                if (CobblemonFightOrFlight.commonConfig().activate_move_effect) {
                    applyPostEffect(pokemonEntity, livingEntity, move, true);
                }
                livingEntity.method_6005(CobblemonFightOrFlight.commonConfig().activate_type_effect ? hurtKnockback * 0.5F : 0.5F, class_3532.method_15374(pokemonEntity.method_36454() * ((float) Math.PI / 180F)), -class_3532.method_15362(pokemonEntity.method_36454() * ((float) Math.PI / 180F)));
            }

            pokemonEntity.method_6114(hurtTarget);
        }
        return flag;
    }

    public static boolean shouldHurtAllyMob(PokemonEntity pokemonEntity, class_1309 target) {
        if (pokemonEntity == null || target == null) {
            return true;
        }
        boolean b = false;
        if (pokemonEntity.method_35057() instanceof class_1657 owner) {
            if (CobblemonFightOrFlight.commonConfig().pvp_immunity) {
                b = target instanceof class_1657;
            }
            if (CobblemonFightOrFlight.commonConfig().friendly_fire_immunity_team) {
                b = b || FOFUtils.teamCheck(pokemonEntity, target);
            }
            if (CobblemonFightOrFlight.commonConfig().friendly_fire_immunity_owner) {
                b = b || owner.equals(target);
                if (target instanceof class_1321 tar) {
                    b = b || owner.equals(tar.method_35057());
                }
            }
            return !b;
        }
        return true;
    }

    public static boolean shouldBeHurtByAllyMob(PokemonEntity pokemonEntity, class_1309 attacker) {
        if (pokemonEntity == null || attacker == null) {
            return true;
        }
        if (pokemonEntity.method_35057() instanceof class_1657 owner) {
            if (CobblemonFightOrFlight.commonConfig().pvp_immunity) {
                return !(attacker instanceof class_1657);
            }
            if (CobblemonFightOrFlight.commonConfig().friendly_fire_immunity_team) {
                return !Objects.equals(owner.method_5781(), attacker.method_5781());
            }
            if (CobblemonFightOrFlight.commonConfig().friendly_fire_immunity_owner) {
                return !owner.equals(attacker);
            }
        }
        return true;
    }
}
