package me.rufia.fightorflight.entity.ai.config.task;

import com.bedrockk.molang.Expression;
import com.bedrockk.molang.runtime.MoLangRuntime;
import com.cobblemon.mod.common.api.ai.BehaviourConfigurationContext;
import com.cobblemon.mod.common.api.ai.ExpressionOrEntityVariableKt;
import com.cobblemon.mod.common.api.ai.config.task.SharedEntityVariables;
import com.cobblemon.mod.common.api.ai.config.task.SingleTaskConfig;
import com.cobblemon.mod.common.api.npc.configuration.MoLangConfigVariable;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import com.mojang.datafixers.util.Either;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.entity.ai.tasks.FOFPokemonRangeTask;
import net.minecraft.class_1309;
import net.minecraft.class_4140;
import net.minecraft.class_7893;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Optional;

public class FOFPokemonRangeTaskConfig implements SingleTaskConfig {
    private final Either<Expression, MoLangConfigVariable> condition = booleanVariable(SharedEntityVariables.ATTACKING_CATEGORY, "attacks_melee", true).asExpressible();
    private final Either<Expression, MoLangConfigVariable> range = numberVariable(SharedEntityVariables.ATTACKING_CATEGORY, "range_radius", 8F).asExpressible();
    private final Either<Expression, MoLangConfigVariable> cooldownTicks = numberVariable(SharedEntityVariables.ATTACKING_CATEGORY, "melee_cooldown", 20).asExpressible();

    @Override
    public @Nullable class_7893<? super class_1309> createTask(@NotNull class_1309 livingEntity, @NotNull BehaviourConfigurationContext behaviourConfigurationContext) {
        var runtime = behaviourConfigurationContext.getRuntime();
        var expression = condition.left();
        if (expression.isPresent() && !MoLangExtensionsKt.resolveBoolean(runtime, expression.get(), MoLangExtensionsKt.getContextOrEmpty(runtime))) {
            return null;
        }
        behaviourConfigurationContext.addMemories(
                class_4140.field_22355,
                class_4140.field_22475
        );
        return new FOFPokemonRangeTask();
    }

    @Override
    public @NotNull List<MoLangConfigVariable> getVariables(@NotNull class_1309 livingEntity, @NotNull BehaviourConfigurationContext behaviourConfigurationContext) {
        List<Either<Expression, MoLangConfigVariable>> list = List.of(condition, range, cooldownTicks);
        return ExpressionOrEntityVariableKt.asVariables(list);
    }
}
