package me.rufia.fightorflight.entity.ai.sensors;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_6670;
import org.jetbrains.annotations.NotNull;
import java.util.Optional;
import java.util.Set;

public class PokemonHelpOwnerSensor extends class_4148<PokemonEntity> {
    private static final int REFRESH_RATE = 1200;

    public PokemonHelpOwnerSensor() {
        super(10);
    }

    @Override
    protected void doTick(class_3218 level, PokemonEntity entity) {
        if (!CobblemonFightOrFlight.commonConfig().do_pokemon_defend_owner) {
            return;
        }
        var owner = entity.method_35057();
        if (owner != null) {
            entity.method_18868().method_18904(class_4140.field_18442).ifPresent(visibleLivingEntities -> {
                setNearestTarget(entity, visibleLivingEntities, owner);
            });
        }
    }

    @Override
    public @NotNull Set<class_4140<?>> method_19099() {
        return Set.of(class_4140.field_22355);
    }

    private void setNearestTarget(PokemonEntity pokemonEntity, class_6670 visibleMobs, class_1309 owner) {
        //Inherit the target. lastHurtBy will be cleared automatically
        int ownerLastHurtTick = ((PokemonInterface) pokemonEntity).getOwnerLastHurtTick();
        var ownerLastHurtTarget = ((PokemonInterface) pokemonEntity).getOwnerLastHurt();
        if (ownerLastHurtTarget != null && ownerLastHurtTarget.method_5805() && pokemonEntity.field_6012 - ownerLastHurtTick < REFRESH_RATE) {
            pokemonEntity.method_18868().method_18878(class_4140.field_22355, ownerLastHurtTarget);
            return;
        }
        //Finding target
        var nearestAttacker = visibleMobs.method_38975(livingEntity -> {
            if (livingEntity instanceof class_3222) {
                return false;
            }
            var lastHurtByMob = livingEntity.method_6065();
            return lastHurtByMob != null && lastHurtByMob.method_5779(owner);
        });
        //Trying to set target
        class_1309 livingEntity = nearestAttacker.orElse(null);
        ((PokemonInterface) pokemonEntity).setOwnerLastHurt(livingEntity);
        if (livingEntity != null) {
            pokemonEntity.method_18868().method_18879(class_4140.field_22355, nearestAttacker);
        }
    }
}
