package me.rufia.fightorflight.entity.ai.sensors;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4148;
import net.minecraft.class_6670;
import org.jetbrains.annotations.NotNull;
import java.util.Optional;
import java.util.Set;

public class PokemonWildProactiveSensor extends class_4148<PokemonEntity> {
    public PokemonWildProactiveSensor() {
        super(10);
    }

    @Override
    protected void doTick(class_3218 level, PokemonEntity entity) {
        if (!PokemonUtils.WildPokemonCanPerformUnprovokedAttack(entity)) {
            return;
        }
        if (CobblemonFightOrFlight.getFightOrFlightCoefficient(entity) <= CobblemonFightOrFlight.AUTO_AGGRO_THRESHOLD() || (CobblemonFightOrFlight.commonConfig().light_dependent_unprovoked_attack && entity.method_5718() >= 0.5f)) {
            return;
        }
        entity.method_18868().method_18904(class_4140.field_18442).ifPresent(visibleLivingEntities -> {
            findTarget(entity, visibleLivingEntities);
        });
    }

    @Override
    public @NotNull Set<class_4140<?>> method_19099() {
        return Set.of(class_4140.field_22355);
    }

    private void findTarget(PokemonEntity pokemonEntity, class_6670 visibleLivingEntities) {
        var nearestPlayer = visibleLivingEntities.method_38975(livingEntity -> {
            if (livingEntity instanceof class_1657 player) {
                return !(player.method_7337() || player.method_7325());
            }
            return false;
        });
        if (pokemonEntity.method_18868().method_18876(class_4140.field_22355, class_4141.field_18457))
            nearestPlayer.ifPresent(player -> {
                pokemonEntity.method_18868().method_18878(class_4140.field_22355, player);
            });
    }

}
