package me.rufia.fightorflight.entity.areaeffect;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.entity.EntityFightOrFlight;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;

public class PokemonWhirlPool extends AbstractPokemonAreaEffect {
    public PokemonWhirlPool(class_1299<? extends AbstractPokemonAreaEffect> entityType, class_1937 level) {
        super(entityType, level);
    }

    public PokemonWhirlPool(class_1309 owner) {
        super(EntityFightOrFlight.WHIRLPOOL.get(), owner.method_37908());
        setOwner(owner);
    }

    @Override
    protected void visualEffect() {
        if (owner instanceof PokemonEntity) {
            if (isWaiting()) {
                PokemonAttackEffect.makeTypeEffectParticle(6, this, getElementalType());
            }
        }
    }

    @Override
    protected void activate() {
        super.activate();
        if (owner instanceof PokemonEntity pokemonEntity && pokemonEntity.method_5805()) {
            dealDamageInTheArea();
        } else {
            method_31472();
        }
    }

    @Override
    protected void applyExtraEffect(class_1309 target) {
        var instance = new class_1293(class_1294.field_5909, 200, 0);
        target.method_37222(instance, owner);
    }
}
