package me.rufia.fightorflight.entity.projectile;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.entity.IPokemonAttack;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1682;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import java.util.Objects;

public abstract class AbstractPokemonProjectile extends class_1682 implements IPokemonAttack {
    private static final class_2940<String> type = class_2945.method_12791(AbstractPokemonProjectile.class, class_2943.field_13326);
    private static final class_2940<Float> damage = class_2945.method_12791(AbstractPokemonProjectile.class, class_2943.field_13320);

    public AbstractPokemonProjectile(class_1299<? extends AbstractPokemonProjectile> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void initPosition(class_1309 shooter) {
        this.method_7432(shooter);
        class_2338 blockPos = shooter.method_24515();
        float angle = shooter.method_36454();
        //CobblemonFightOrFlight.LOGGER.info(String.valueOf(angle));
        double radius = 0.5 * shooter.method_17681();
        double d = (double) blockPos.method_10263() + 0.5 - radius * Math.sin(angle);
        double e = (double) blockPos.method_10264() + Math.max(0.3f, shooter.method_17682() * 0.67);
        double f = (double) blockPos.method_10260() + 0.5 + radius * Math.cos(angle);
        this.method_5808(d, e, f, this.method_36454(), this.method_36455());
    }

    public void method_5773() {
        super.method_5773();
        if (shoudlCreateParticle()) {
            makeParticle(2);
        }
    }

    protected boolean shoudlCreateParticle() {
        return true;
    }

    @Override
    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10582("Type", this.field_6011.method_12789(type));
        compound.method_10548("Damage", this.field_6011.method_12789(damage));
    }

    @Override
    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.field_6011.method_12778(type, compound.method_10558("Type"));
        this.field_6011.method_12778(damage, compound.method_10583("Damage"));
    }

    protected void makeParticle(int particleAmount) {
        if (getElementalType() == null) {
            return;
        }
        PokemonAttackEffect.makeTypeEffectParticle(particleAmount, this, getElementalType());
    }

    public float getDamage() {
        return this.field_6011.method_12789(damage);
    }

    public void setDamage(float Damage) {
        this.field_6011.method_12778(damage, Damage);
    }

    @Override
    public String getElementalType() {
        return this.field_6011.method_12789(type);
    }

    @Override
    public void setElementalType(String Type) {
        this.field_6011.method_12778(type, Type);
    }

    public void applyTypeEffect(PokemonEntity pokemonEntity, class_1309 hurtTarget) {
        if (!Objects.equals(getElementalType(), pokemonEntity.getPokemon().getPrimaryType().getName())) {
            PokemonAttackEffect.applyTypeEffect(pokemonEntity, hurtTarget, getElementalType());
        } else {
            PokemonAttackEffect.applyTypeEffect(pokemonEntity, hurtTarget);
        }
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(type, "normal");
        builder.method_56912(damage, 1f);
    }

    protected void method_7454(class_3966 result) {
        super.method_7454(result);
        class_1297 owner = method_24921();
        class_1297 target = result.method_17782();
        if (owner instanceof PokemonEntity pokemonEntity && target instanceof class_1309) {
            Move move = PokemonUtils.getMove(pokemonEntity);
            PokemonUtils.setHurtByPlayer(pokemonEntity, target);
            PokemonAttackEffect.applyOnHitVisualEffect(pokemonEntity, target, move);
        }
    }

    @Override
    protected boolean method_26958(class_1297 target) {
        return target != method_24921() && super.method_26958(target);
    }

    protected void method_24920(class_3965 result) {
        super.method_24920(result);
    }

    public void accurateShoot(double x, double y, double z, float velocity, float inaccuracy) {
        double horizontalDistance = Math.sqrt(x * x + z * z);
        float g = (float) method_56989();
        double v2 = velocity * velocity;
        double sqrtDelta = Math.sqrt(v2 * v2 - 2 * v2 * g * y - g * g * horizontalDistance * horizontalDistance);
        double t = Math.sqrt(2 * (v2 - g * y - sqrtDelta)) / g;
        double vy = 0.5 * g * t + y;
        //CobblemonFightOrFlight.LOGGER.info("{},{},{},{}", x, vy, z, t);
        this.method_7485(x, y, z, velocity, inaccuracy);
    }
}
