package me.rufia.fightorflight.entity.projectile;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.entity.EntityFightOrFlight;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.utils.PokemonUtils;
import me.rufia.fightorflight.utils.TypeEffectiveness;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;


public class PokemonFloatingSpike extends AbstractPokemonSpike {
    protected short remainingFloatingTime;

    public PokemonFloatingSpike(class_1299<? extends AbstractPokemonProjectile> entityType, class_1937 level) {
        super(entityType, level);
    }

    public PokemonFloatingSpike(class_1937 level, class_1309 shooter) {
        super(EntityFightOrFlight.FLOATING_SPIKE.get(), level);
        activated = false;
        life = 0;
        inGround = false;
        remainingFloatingTime = 0;
        initPosition(shooter);
    }

    @Override
    protected void onActivated() {
        remainingFloatingTime = (short) method_37908().field_9229.method_39332(8, 12);
    }

    @Override
    public void method_5773() {
        if (remainingFloatingTime > 0) {
            --remainingFloatingTime;
        }
        super.method_5773();
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10575("remainingFloatingTime", remainingFloatingTime);
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10573("remainingFloatingTime", class_2487.field_33252)) {
            remainingFloatingTime = compound.method_10568("remainingFloatingTime");
        }
    }

    @Override
    protected void hurtEntity(class_1309 target) {
        if (method_24921() instanceof PokemonEntity pokemonEntity) {
            if (PokemonAttackEffect.shouldHurtAllyMob(pokemonEntity, target)) {
                class_1282 damageSource = this.method_48923().method_48815(this, pokemonEntity);
                float multiplier = target instanceof PokemonEntity pokemon ? TypeEffectiveness.getTypeEffectivenessSimple("rock", pokemon) : 1f;
                if (target.method_5643(damageSource, multiplier * CobblemonFightOrFlight.moveConfig().spike_basic_damage)) {
                    pokemonEntity.method_6015(pokemonEntity);
                    PokemonUtils.setHurtByPlayer(pokemonEntity, target);
                }
            }
        }
    }

    @Override
    protected double method_7490() {
        double g = super.method_7490();
        if (activated) {
            if (remainingFloatingTime > 0) {
                return -g;
            } else {
                class_243 v = method_18798();
                if (v.field_1351 > 0) {
                    method_18800(v.field_1352, 0, v.field_1350);
                }
                return 0;
            }
        }

        return g;
    }
}
