package me.rufia.fightorflight.entity.projectile;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.entity.EntityFightOrFlight;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import java.util.Objects;

public class PokemonSpike extends AbstractPokemonSpike {
    public PokemonSpike(class_1299<? extends AbstractPokemonProjectile> entityType, class_1937 level) {
        super(entityType, level);
    }

    public PokemonSpike(class_1937 level, class_1309 shooter) {
        super(EntityFightOrFlight.SPIKE.get(), level);
        activated = false;
        life = 0;
        inGround = false;
        initPosition(shooter);
    }

    @Override
    protected void hurtEntity(class_1309 target) {
        if (method_24921() instanceof PokemonEntity pokemonEntity) {
            if (PokemonAttackEffect.shouldHurtAllyMob(pokemonEntity, target)) {
                if (Objects.equals(getElementalType(), "Poison")) {
                    target.method_37222(new class_1293(class_1294.field_5899, 200, 0), pokemonEntity);
                } else {
                    class_1282 damageSource = this.method_48923().method_48815(this, pokemonEntity);
                    if (target.method_5643(damageSource, CobblemonFightOrFlight.moveConfig().spike_basic_damage)) {
                        pokemonEntity.method_6015(pokemonEntity);
                        PokemonUtils.setHurtByPlayer(pokemonEntity, target);
                    }
                }
            }
        }
    }
}
