package me.rufia.fightorflight.goals;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_1352;
import net.minecraft.class_2338;

public class PokemonGoToPosGoal extends class_1352 {
    private final PokemonEntity pokemonEntity;
    private final double speedModifier;
    private boolean stuck;

    public PokemonGoToPosGoal(PokemonEntity entity, double speedModifier) {
        pokemonEntity = entity;
        this.speedModifier = speedModifier;

    }

    protected boolean moveCommand() {
        return PokemonUtils.moveCommandAvailable(pokemonEntity)
                || PokemonUtils.moveAttackCommandAvailable(pokemonEntity);
    }

    protected boolean stayCommand() {
        return PokemonUtils.stayCommandAvailable(pokemonEntity);
    }

    @Override
    public boolean method_6264() {
        return (moveCommand() && !isCloseEnough()) || stayCommand();
    }

    @Override
    public boolean method_6266() {
        return method_6264();
    }

    public void method_6269() {
        stuck = false;
    }

    public void method_6268() {
        if (moveCommand()) {
            approach();
        } else if (stayCommand()) {
            if (!isCloseEnough()) {
                approach();
            }
        }
    }

    public void method_6270() {
        PokemonUtils.finishMoving(pokemonEntity);
    }

    protected void approach() {
        PokemonUtils.pokemonEntityApproachPos(pokemonEntity, getBlockPos(), speedModifier);
    }

    protected class_2338 getBlockPos() {
        return ((PokemonInterface) pokemonEntity).getTargetBlockPos();
    }

    protected boolean isCloseEnough() {
        return getBlockPos().method_19769(pokemonEntity.method_19538(), 2);
    }
}
