package me.rufia.fightorflight.goals.targeting;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.utils.TargetingWhitelist;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1405;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_4051;
import java.util.EnumSet;

public class CaughtByTargetGoal extends class_1405 {
    private static final class_4051 HURT_BY_TARGETING = class_4051.method_36625().method_36627().method_18424();
    private class_1309 lastCaughtByMob;

    public CaughtByTargetGoal(class_1308 mob) {
        super(mob, true, false);
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
    }

    public boolean method_6264() {
        if (!CobblemonFightOrFlight.commonConfig().failed_capture_counted_as_provocation) {
            return false;
        }
        PokemonEntity pokemonEntity = (PokemonEntity) this.field_6660;
        if (pokemonEntity.method_35057() != null) {
            return false;
        }
        int mobID = ((PokemonInterface) pokemonEntity).getCapturedBy();
        if (mobID != 0) {
            class_1297 target = field_6660.method_37908().method_8469(mobID);
            if (target != null && TargetingWhitelist.getWhitelist(pokemonEntity).contains(target.method_5653())) {
                return false;//I don't know who will list the player in the list, but just let it happen.
            }
            if (target instanceof class_1309 livingEntity) {
                lastCaughtByMob = livingEntity;
            }
        }
        if (lastCaughtByMob != null) {
            if (lastCaughtByMob.method_5864() == class_1299.field_6097 && this.field_6660.method_37908().method_8450().method_8355(class_1928.field_25402)) {
                return false;
            } else {
                return this.method_6328(lastCaughtByMob, HURT_BY_TARGETING);
            }
        } else {
            return false;
        }
    }

    public void method_6269() {
        this.field_6660.method_5980(lastCaughtByMob);
        this.field_6664 = this.field_6660.method_5968();
        this.field_6660.method_6015(this.field_6660.method_5968());
        if (this.field_6660.method_5968() instanceof class_1657) {
            this.field_6660.method_29505((class_1657) this.field_6660.method_5968());
        }
        this.field_6657 = 300;
        super.method_6269();
    }
}
