package me.rufia.fightorflight.item.component;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_1799;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record PokeStaffComponent(String mode, int moveSlot, String cmdmode) {
    public enum MODE {
        SEND, SETMOVE, SETCMDMODE
    }

    public enum CMDMODE {
        MOVE_ATTACK, MOVE, STAY, ATTACK, ATTACK_POSITION, NOCMD, CLEAR
    }

    public static final Codec<PokeStaffComponent> CODEC;
    public static final class_9139<ByteBuf, PokeStaffComponent> STREAM_CODEC;

    public void setMode(String val, class_1799 itemStack) {
        itemStack.method_57379(ItemComponentFOF.POKE_STAFF_COMMAND_MODE_COMPONENT, new PokeStaffComponent(val, moveSlot, cmdmode));
    }

    public void setMoveSlot(int val, class_1799 itemStack) {
        itemStack.method_57379(ItemComponentFOF.POKE_STAFF_COMMAND_MODE_COMPONENT, new PokeStaffComponent(mode, val, cmdmode));
    }

    public void setCmdmode(String val, class_1799 itemStack) {
        itemStack.method_57379(ItemComponentFOF.POKE_STAFF_COMMAND_MODE_COMPONENT, new PokeStaffComponent(mode, moveSlot, val));
    }

    public static String getNextMode(String val) {
        String result;
        switch (PokeStaffComponent.MODE.valueOf(val)) {
            case SETMOVE -> result = MODE.SETCMDMODE.name();
            case SEND -> result = MODE.SETMOVE.name();
            case SETCMDMODE -> result = MODE.SEND.name();
            default -> result = MODE.SETCMDMODE.name();
        }
        return result;
    }

    static {
        CODEC = RecordCodecBuilder.create(
                (instance) -> instance.group(
                                Codec.STRING.optionalFieldOf("mode", MODE.SETMOVE.name()).forGetter(PokeStaffComponent::mode),
                                Codec.INT.optionalFieldOf("moveSlot", 0).forGetter(PokeStaffComponent::moveSlot),
                                Codec.STRING.optionalFieldOf("command", CMDMODE.NOCMD.name()).forGetter(PokeStaffComponent::cmdmode)
                        )
                        .apply(instance, PokeStaffComponent::new));
        STREAM_CODEC = class_9139.method_56436(
                class_9135.field_48554, PokeStaffComponent::mode,
                class_9135.field_49675, PokeStaffComponent::moveSlot,
                class_9135.field_48554, PokeStaffComponent::cmdmode,
                PokeStaffComponent::new);
    }
}
