package me.rufia.fightorflight.mixin;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1508;
import net.minecraft.class_1510;
import net.minecraft.class_1526;
import net.minecraft.class_1527;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1510.class)
public abstract class EnderDragonMixin extends class_1309 {
    @Shadow
    @Final
    private class_1526 phaseManager;


    @Shadow
    @Final
    public class_1508 head;

    @Shadow
    protected abstract boolean reallyHurt(class_1282 damageSource, float amount);

    @Shadow
    private float sittingDamageReceived;

    protected EnderDragonMixin(class_1299<? extends class_1309> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(method = "hurt(Lnet/minecraft/world/entity/boss/EnderDragonPart;Lnet/minecraft/world/damagesource/DamageSource;F)Z", at = @At("HEAD"), cancellable = true)
    private void hurtInject(class_1508 part, class_1282 source, float damage, CallbackInfoReturnable<Boolean> cir) {
        if (this.phaseManager.method_6864().method_6849() == class_1527.field_7068) {
            cir.setReturnValue(false);
        } else {
            damage = this.phaseManager.method_6864().method_6852(source, damage);
            if (part != this.head) {
                damage = damage / 4.0F + Math.min(damage, 1.0F);
            }

            if (damage < 0.01F) {
                cir.setReturnValue(false);
            } else {
                if (source.method_5529() instanceof PokemonEntity pokemonEntity) {
                    boolean isPlayerOwned = pokemonEntity.getPokemon().isPlayerOwned();
                    if (isPlayerOwned && CobblemonFightOrFlight.commonConfig().player_pokemon_can_hurt_ender_dragon || !isPlayerOwned && CobblemonFightOrFlight.commonConfig().wild_pokemon_can_hurt_ender_dragon) {
                        float f = this.method_6032();
                        this.reallyHurt(source, damage);
                        if (this.method_29504() && !this.phaseManager.method_6864().method_6848()) {
                            this.method_6033(1.0F);
                            this.phaseManager.method_6863(class_1527.field_7068);
                        }
                        if (this.phaseManager.method_6864().method_6848()) {
                            this.sittingDamageReceived = this.sittingDamageReceived + f - this.method_6032();
                            if (this.sittingDamageReceived > 0.25F * this.method_6063()) {
                                this.sittingDamageReceived = 0.0F;
                                this.phaseManager.method_6863(class_1527.field_7077);
                            }
                        }
                        cir.setReturnValue(true);
                    }
                }
            }
        }
    }

}
