package me.rufia.fightorflight.mixin;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.server.BattleChallengePacket;
import com.cobblemon.mod.common.net.messages.server.RequestPlayerInteractionsPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.client.keybinds.CommandKeybind;
import me.rufia.fightorflight.client.keybinds.KeybindFightOrFlight;
import me.rufia.fightorflight.item.ItemFightOrFlight;
import me.rufia.fightorflight.item.component.PokeStaffComponent;
import me.rufia.fightorflight.net.packet.SendCommandPacket;
import me.rufia.fightorflight.net.packet.SendMoveSlotPacket;
import me.rufia.fightorflight.utils.FOFUtils;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_310.class)
public abstract class MinecraftClientInject {
    @Shadow
    public static class_310 getInstance() {
        return null;
    }

    @Shadow
    @Nullable
    public class_746 player;

    @Inject(method = "handleKeybinds", at = @At("TAIL"))
    private void postTick(CallbackInfo ci) {
        if (KeybindFightOrFlight.START_BATTLE.method_1436()) {
            startBattle();
        }
        if (KeybindFightOrFlight.MOVE_SLOT_1.method_1436()) {
            sendMoveSlotPacket(KeybindFightOrFlight.MOVE_SLOT_1.getMoveSlot());
        } else if (KeybindFightOrFlight.MOVE_SLOT_2.method_1436()) {
            sendMoveSlotPacket(KeybindFightOrFlight.MOVE_SLOT_2.getMoveSlot());
        } else if (KeybindFightOrFlight.MOVE_SLOT_3.method_1436()) {
            sendMoveSlotPacket(KeybindFightOrFlight.MOVE_SLOT_3.getMoveSlot());
        } else if (KeybindFightOrFlight.MOVE_SLOT_4.method_1436()) {
            sendMoveSlotPacket(KeybindFightOrFlight.MOVE_SLOT_4.getMoveSlot());
        }
        for (CommandKeybind keybind : KeybindFightOrFlight.commandKeybinds) {
            if (keybind.method_1436()) {
                sendCommandModePacket(keybind.getCmdmode());
                break;
            }
        }
    }

    private void sendMoveSlotPacket(int moveSlot) {
        if (getInstance() == null) {
            return;
        }
        var player = getInstance().field_1724;
        if (player != null) {
            if (PokemonUtils.shouldCheckPokeStaff()) {
                var stack = player.method_6047();
                if (!stack.method_31574(ItemFightOrFlight.POKESTAFF.get())) {
                    if (!player.method_6079().method_31574(ItemFightOrFlight.POKESTAFF.get())) {
                        return;
                    }
                }
            }
            int slot = CobblemonClient.INSTANCE.getStorage().getSelectedSlot();
            NetworkManager.sendToServer(new SendMoveSlotPacket(slot, moveSlot));
        }
    }

    private void sendCommandModePacket(PokeStaffComponent.CMDMODE cmdmode) {
        var player = getInstance().field_1724;
        if (player == null) {
            return;
        }
        String cmdData = FOFUtils.createCommandData(player, cmdmode);
        int slot = CobblemonClient.INSTANCE.getStorage().getSelectedSlot();
        NetworkManager.sendToServer(new SendCommandPacket(slot, cmdmode.name(), cmdData));
    }

    private void startBattle() {
        var player = getInstance().field_1724;
        boolean isSpectator = player.method_7325();
        boolean playerIsNotAvailable = CobblemonClient.INSTANCE.getBattle() != null;
        boolean otherConditions = !(CobblemonClient.INSTANCE.getStorage().getSelectedSlot() != -1 && getInstance().field_1755 == null);
        if (isSpectator || playerIsNotAvailable || otherConditions) {
            return;
        }

        Pokemon pokemon = CobblemonClient.INSTANCE.getStorage().getParty().get(CobblemonClient.INSTANCE.getStorage().getSelectedSlot());
        if (pokemon != null && pokemon.getCurrentHealth() > 0) {
            var entities = player.field_17892.method_8390(PokemonEntity.class, class_238.method_30048(player.method_30950(player.field_6012), 16, 16, 16),
                    (pokemonEntity) -> pokemonEntity.method_5968() == player
            );
            for (PokemonEntity pokemonEntity : entities) {
                if (pokemonEntity.method_35057() == null && pokemonEntity.canBattle(player)) {
                    BattleChallengePacket packet = new BattleChallengePacket(pokemonEntity.method_5628(), pokemon.getUuid(), BattleFormat.Companion.getGEN_9_SINGLES());
                    CobblemonNetwork.sendToServer(packet);
                    break;
                } else if (pokemonEntity.method_35057() != player) {
                    if (pokemonEntity.method_35057() instanceof class_1657) {
                        CobblemonNetwork.sendToServer(new RequestPlayerInteractionsPacket(pokemonEntity.method_5667(), pokemonEntity.method_5628(), pokemon.getUuid()));
                        //break;
                    }
                } else {
                }
            }
        }
    }
}
