package me.rufia.fightorflight.mixin;


import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.pokemon.experience.SidemodExperienceSource;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.data.movedata.MoveData;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.entity.ai.sensors.FOFSensors;
import me.rufia.fightorflight.item.component.PokeStaffComponent;
import me.rufia.fightorflight.utils.*;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1471;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4149;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.*;

@Mixin(PokemonEntity.class)
public abstract class PokemonEntityMixin extends class_1308 implements PokemonInterface {
    @Shadow(remap = false)
    public abstract void cry();

    @Shadow(remap = false)
    public abstract Pokemon getPokemon();

    @Unique
    @Nullable
    private class_1309 fightorflight$clientSideCachedAttackTarget;
    @Unique
    @Nullable
    private class_1309 ownerLastHurt;
    @Unique
    private int ownerLastHurtTick = 0;
    @Unique
    private static final class_2940<Integer> DATA_ID_ATTACK_TARGET;
    @Unique
    private static final class_2940<Integer> DATA_ID_CAPTURED_BY;
    @Unique
    private static final class_2940<Integer> ATTACK_MODE;
    @Unique
    private static final class_2940<Integer> ATTACK_TIME;
    @Unique
    private static final class_2940<Integer> MAX_ATTACK_TIME;
    @Unique
    private static final class_2940<String> MOVE;
    @Unique
    private static final class_2940<Integer> CRY_CD;
    @Unique
    private static final class_2940<String> COMMAND;
    @Unique
    private static final class_2940<String> COMMAND_DATA;
    @Unique
    private static final class_2940<class_2338> TARGET_BLOCK_POS;

    @Unique
    private static final class_2940<Integer> MOVE_DURATION;

    @Unique
    private final List<FOFMove> MOVES_FOF = new ArrayList<>();//This should only be accessed in the server side!

    static {
        DATA_ID_ATTACK_TARGET = class_2945.method_12791(PokemonEntityMixin.class, class_2943.field_13327);
        DATA_ID_CAPTURED_BY = class_2945.method_12791(PokemonEntityMixin.class, class_2943.field_13327);
        ATTACK_TIME = class_2945.method_12791(PokemonEntityMixin.class, class_2943.field_13327);
        MAX_ATTACK_TIME = class_2945.method_12791(PokemonEntityMixin.class, class_2943.field_13327);
        MOVE = class_2945.method_12791(PokemonEntityMixin.class, class_2943.field_13326);
        CRY_CD = class_2945.method_12791(PokemonEntityMixin.class, class_2943.field_13327);
        COMMAND = class_2945.method_12791(PokemonEntityMixin.class, class_2943.field_13326);
        COMMAND_DATA = class_2945.method_12791(PokemonEntityMixin.class, class_2943.field_13326);
        TARGET_BLOCK_POS = class_2945.method_12791(PokemonEntityMixin.class, class_2943.field_13324);
        ATTACK_MODE = class_2945.method_12791(PokemonEntityMixin.class, class_2943.field_13327);//0 means the pokemon can't attack, 1 for melee, 2 for range attack.
        MOVE_DURATION = class_2945.method_12791(PokemonEntityMixin.class, class_2943.field_13327);
    }

    protected void createTargetBlockPos() {
        String data = this.getCommandData();
        class_2338 blockPos = class_2338.field_10980;
        if (data.startsWith("POS_")) {
            if (data.equals("POS_SELF")) {
                blockPos = new class_2338(method_31477(), method_31479(), method_31479());
            }
        } else {
            class_2382 vec3i = FOFUtils.stringToVec3i(data);
            if (vec3i != null) {
                blockPos = new class_2338(vec3i.method_10263(), vec3i.method_10264(), vec3i.method_10260());
            }
        }
        setTargetBlockPos(blockPos);
    }

    protected PokemonEntityMixin(class_1299<? extends class_1471> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    public class_1309 method_5968() {
        if (this.method_37908().field_9236) {
            if (fightorflight$clientSideCachedAttackTarget != null) {
                return fightorflight$clientSideCachedAttackTarget;
            } else {
                class_1297 entity = this.method_37908().method_8469(this.field_6011.method_12789(DATA_ID_ATTACK_TARGET));
                if (entity instanceof class_1309) {
                    fightorflight$clientSideCachedAttackTarget = (class_1309) entity;
                    return fightorflight$clientSideCachedAttackTarget;
                }
            }
        }
        return super.method_5968();
    }

    @Inject(method = "onSyncedDataUpdated", at = @At("TAIL"))
    public void onSyncedDataUpdated(class_2940<?> key, CallbackInfo ci) {
        if (DATA_ID_ATTACK_TARGET.equals(key)) {
            this.fightorflight$clientSideCachedAttackTarget = null;
        }
    }

    @Inject(method = "defineSynchedData", at = @At("TAIL"))
    protected void defineSynchedData(class_2945.class_9222 builder, CallbackInfo callbackInfo) {
        builder.method_56912(DATA_ID_ATTACK_TARGET, 0);
        builder.method_56912(DATA_ID_CAPTURED_BY, 0);
        builder.method_56912(ATTACK_TIME, 0);
        builder.method_56912(MAX_ATTACK_TIME, -1);
        builder.method_56912(MOVE, "");
        builder.method_56912(CRY_CD, 0);
        builder.method_56912(COMMAND, "");
        builder.method_56912(COMMAND_DATA, "");
        builder.method_56912(TARGET_BLOCK_POS, class_2338.field_10980);
        builder.method_56912(ATTACK_MODE, 0);
        builder.method_56912(MOVE_DURATION, 0);
    }

    @Inject(method = "saveWithoutId", at = @At("HEAD"))
    private void writeAdditionalNbt(class_2487 compoundTag, CallbackInfoReturnable<Boolean> ci) {
        compoundTag.method_10569(CRY_CD.toString(), 0);
    }

    @Inject(method = "load", at = @At("TAIL"))
    private void readAdditionalNbt(class_2487 compoundTag, CallbackInfo ci) {
        field_6011.method_12778(CRY_CD, compoundTag.method_10550(CRY_CD.toString()));
    }

    @ModifyVariable(method = "assignNewBrainWithMemoriesAndSensors", at = @At("HEAD"), argsOnly = true, index = 3)
    private Set<class_4149<?>> assignNewBrainWithMemoriesAndSensorsMixin(Set<class_4149<?>> sensors) {
        HashSet<class_4149<?>> hashSet = new HashSet<>(sensors);
        hashSet.add(FOFSensors.POKEMON_HELP_OWNER);
        hashSet.add(FOFSensors.POKEMON_WILD_PROACTIVE);
        return Set.copyOf(hashSet);
    }

    public void method_5980(class_1309 target) {
        super.method_5980(target);
        if (target != null) {
            this.field_6011.method_12778(DATA_ID_ATTACK_TARGET, target.method_5628());
        }
    }

    @Override
    public int getAttackTime() {
        return field_6011.method_12789(ATTACK_TIME);
    }

    @Override
    public void setAttackTime(int val) {
        field_6011.method_12778(ATTACK_TIME, val);
    }

    @Override
    public int getMaxAttackTime() {
        return field_6011.method_12789(MAX_ATTACK_TIME);
    }

    @Override
    public void setMaxAttackTime(int val) {
        field_6011.method_12778(MAX_ATTACK_TIME, val);
    }

    @Override
    public boolean usingBeam() {
        if (getCurrentMove().isEmpty()) {
            return false;
        }
        return Arrays.stream(CobblemonFightOrFlight.moveConfig().single_beam_moves).toList().contains(getCurrentMove());
    }

    @Override
    public boolean usingSound() {
        if (getCurrentMove().isEmpty()) {
            return false;
        }
        return Arrays.stream(CobblemonFightOrFlight.moveConfig().sound_based_moves).toList().contains(getCurrentMove());
    }

    @Override
    public boolean usingMagic() {
        if (getCurrentMove().isEmpty()) {
            return false;
        }
        return Arrays.stream(CobblemonFightOrFlight.moveConfig().magic_attack_moves).toList().contains(getCurrentMove());
    }

    @Override
    public void setCurrentMove(Move move) {
        field_6011.method_12778(MOVE, move.getName());
    }

    @Override
    public String getCurrentMove() {
        return field_6011.method_12789(MOVE);
    }

    @Override
    public int getNextCryTime() {
        return this.field_6011.method_12789(CRY_CD);
    }

    @Override
    public void setNextCryTime(int time) {
        this.field_6011.method_12778(CRY_CD, time);
    }

    @Override
    public void setCommand(String cmd) {
        field_6011.method_12778(COMMAND, cmd);
    }

    @Override
    public String getCommand() {
        return field_6011.method_12789(COMMAND);
    }

    @Override
    public void setCommandData(String cmdData) {
        field_6011.method_12778(COMMAND_DATA, cmdData);
        createTargetBlockPos();
    }

    @Override
    public String getCommandData() {
        return field_6011.method_12789(COMMAND_DATA);
    }

    @Override
    public class_2338 getTargetBlockPos() {
        return this.field_6011.method_12789(TARGET_BLOCK_POS);
    }

    @Override
    public void setTargetBlockPos(class_2338 blockPos) {
        this.field_6011.method_12778(TARGET_BLOCK_POS, blockPos);
    }

    @Override
    public int getCapturedBy() {
        return field_6011.method_12789(DATA_ID_CAPTURED_BY);
    }

    @Override
    public void setCapturedBy(int id) {
        field_6011.method_12778(DATA_ID_CAPTURED_BY, id);
    }

    @Override
    public int getAttackMode() {
        return field_6011.method_12789(ATTACK_MODE);
    }

    @Override
    public void setAttackMode(int attackMode) {
        field_6011.method_12778(ATTACK_MODE, attackMode);
    }

    @Override
    public int getMoveDuration() {
        return field_6011.method_12789(MOVE_DURATION);
    }

    @Override
    public void setMoveDuration(int duration) {
        field_6011.method_12778(MOVE_DURATION, duration);
    }

    @Override
    public int getOwnerLastHurtTick() {
        return ownerLastHurtTick;
    }

    @Override
    public class_1309 getOwnerLastHurt() {
        return ownerLastHurt;
    }

    @Override
    public void setOwnerLastHurt(@Nullable class_1309 livingEntity) {
        ownerLastHurt = livingEntity;
        ownerLastHurtTick = field_6012;
    }

    @ModifyVariable(method = "hurt", at = @At("HEAD"), argsOnly = true)
    private float hurtDamageTweak(float amount) {
        if (PokemonUtils.shouldRetreat((PokemonEntity) (Object) this)) {
            PokemonAttackEffect.pokemonRecallWithAnimation((PokemonEntity) (Object) this);
            return 0;
        }
        PokemonMultipliers pokemonMultipliers = new PokemonMultipliers((PokemonEntity) (Object) this);
        Pokemon pokemon = getPokemon();
        int specialDef = (int) (pokemon.getSpecialDefence() * (FOFHeldItemManager.canUse(pokemon, CobblemonItems.ASSAULT_VEST) ? 1.3f : 1f));
        float def = Math.max(pokemon.getDefence(), specialDef);
        return amount * (1 - pokemonMultipliers.getMaximumDamageReduction() * Math.min(CobblemonFightOrFlight.commonConfig().max_damage_reduction_multiplier, class_3532.method_16439(def / CobblemonFightOrFlight.commonConfig().defense_stat_limit, 0, CobblemonFightOrFlight.commonConfig().max_damage_reduction_multiplier)));
    }

    @Override
    protected void method_6074(class_1282 damageSource, float damageAmount) {
        float prevHealth = method_6032();
        super.method_6074(damageSource, damageAmount);
        if (PokemonUtils.isUsingNewHealthMechanic() && field_6008 == 20) {
            float newHealth = method_6032();
            float d = newHealth - prevHealth;
            if (d < 0) {
                PokemonUtils.entityHpToPokemonHp((PokemonEntity) (Object) this, -d, false);
            }
        }
        if (CobblemonFightOrFlight.commonConfig().slow_down_after_hurt) {
            if (!getPokemon().isPlayerOwned()) {
                method_6092(new class_1293(class_1294.field_5909, 100, 0));
            }
        }
        if (damageSource.method_49708(class_8111.field_42360) && damageAmount > 0) {
            PokemonEntity pokemonEntity = (PokemonEntity) (Object) this;
            var entity = damageSource.method_5529();
            if (entity instanceof class_1309 livingEntity) {
                if (FOFHeldItemManager.canUse(pokemonEntity, CobblemonItems.ROCKY_HELMET)) {
                    entity.method_5643(method_48923().method_48818(pokemonEntity), livingEntity.method_6063() / 6);
                }
                if (PokemonUtils.abilityIs(pokemonEntity, "roughskin") || PokemonUtils.abilityIs(pokemonEntity, "ironbarbs")) {
                    entity.method_5643(method_48923().method_48818(pokemonEntity), livingEntity.method_6063() / 8);
                }
            }
        }
    }

    @Inject(method = "hurt", at = @At("HEAD"), cancellable = true)
    private void hurtImmune(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (CobblemonFightOrFlight.commonConfig().suffocation_immunity && source.method_48792().equals(method_48923().method_48822().method_48792())) {
            cir.setReturnValue(false);
        }
        if (source.method_5529() instanceof class_1309 livingEntity) {
            if (!PokemonAttackEffect.shouldBeHurtByAllyMob(((PokemonEntity) (Object) this), livingEntity)) {
                cir.setReturnValue(false);
            }
        }
    }

    @Override
    public void method_6025(float healAmount) {
        if (PokemonUtils.isUsingNewHealthMechanic()) {
            PokemonUtils.entityHpToPokemonHp((PokemonEntity) (Object) this, healAmount, true);
        }
        super.method_6025(healAmount);
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void tick(CallbackInfo ci) {
        if (Objects.equals(getCommand(), PokeStaffComponent.CMDMODE.CLEAR.name())) {
            setCommand(PokeStaffComponent.CMDMODE.NOCMD.name());
        }
        var targetEntity = PokemonUtils.getTarget((PokemonEntity) (Object) this);
        if (targetEntity != null && targetEntity.method_5805()) {
            if (getNextCryTime() == 0) {
                this.cry();
                if (CobblemonFightOrFlight.commonConfig().multiple_cries) {
                    setNextCryTime(CobblemonFightOrFlight.commonConfig().time_to_cry_again);
                } else {
                    setNextCryTime(-1);
                }
            }
        } else {
            setNextCryTime(0);
        }
        if (getNextCryTime() >= 0) {
            setNextCryTime(getNextCryTime() - 1);
        }
        int attackTime = getAttackTime();
        if (attackTime > -1) {
            setAttackTime(attackTime - 1);
        }
        if (!method_37908().field_9236) {
            int t = field_6012 % 20;
            int sec = field_6012 / 20;
            slowTick(t, sec);
        }
    }

    @Override
    public void tryUsingStatusMoves() {
        if (getAttackTime() > 0) {
            return;
        }
        PokemonEntity self = (PokemonEntity) (Object) this;
        if (self.method_35057() instanceof class_1657 && !FOFHeldItemManager.canUse(self, CobblemonItems.ASSAULT_VEST)) {
            Move move = PokemonUtils.getStatusMove(self);
            if (move != null && CobblemonFightOrFlight.commonConfig().activate_move_effect && MoveData.moveData.containsKey(move.getName())) {
                for (MoveData data : MoveData.moveData.get(move.getName())) {
                    data.invoke(self, null);
                }
                PokemonUtils.makeParticle(10, self, class_2398.field_11211);
                PokemonUtils.sendAnimationPacket(self, "status");
                setAttackTime(300);
                setMaxAttackTime(300);
            }
        }
    }

    @Unique
    private void slowTick(int ticks, int sec) {
        //CobblemonFightOrFlight.LOGGER.info("slowTick...");//It works
        if (ticks == 11) {
            updateAttackMode();
            backendMoveCooldown();
        }
        if (sec % 5 == 0 && ticks == 17) {
            turnBasedHeldItemTrigger();
        }
    }

    @Unique
    private void turnBasedHeldItemTrigger() {
        if (!FOFHeldItemManager.canUseHeldItemHPInfluencing()) {
            return;
        }
        PokemonEntity pokemonEntity = (PokemonEntity) (Object) this;
        Pokemon pokemon = pokemonEntity.getPokemon();
        float maxHealth = pokemonEntity.method_6063();
        if (FOFHeldItemManager.canUse(pokemonEntity, CobblemonItems.LEFTOVERS)) {
            method_6025(maxHealth / 16);
        } else if (FOFHeldItemManager.canUse(pokemonEntity, CobblemonItems.STICKY_BARB)) {
            if (!PokemonUtils.abilityIs(pokemonEntity, "magicguard")) {
                method_5643(method_48923().method_48831(), maxHealth / 8);
            }
        } else if (FOFHeldItemManager.canUse(pokemonEntity, CobblemonItems.BLACK_SLUDGE)) {
            if (PokemonUtils.hasType(pokemon, ElementalTypes.INSTANCE.getPOISON())) {
                method_6025(maxHealth / 16);
            } else {
                if (!PokemonUtils.abilityIs(pokemonEntity, "magicguard")) {
                    method_5643(method_48923().method_48831(), maxHealth / 8);
                }
            }
        }
    }

    @Unique
    private void backendMoveCooldown() {
        //CobblemonFightOrFlight.LOGGER.info("{}-{} {}:backend move running cooldown", tickCount, lastActivatedTick, getPokemon().getSpecies().getName());
        String moveName = getCurrentMove();
        for (FOFMove move : MOVES_FOF) {
            if (!Objects.equals(move.getName(), moveName)) {
                int remainingTime = move.getRemainingCooldown();
                if (remainingTime > 25) {
                    move.setRemainingCooldown(remainingTime - 20);
                }
            }
        }
    }

    @Unique
    private void updateAttackMode() {
        PokemonEntity pokemonEntity = (PokemonEntity) (Object) this;
        Pokemon pokemon = pokemonEntity.getPokemon();
        Move move = PokemonUtils.getMove(pokemonEntity);
        boolean attackIsHigher = pokemon.getAttack() > pokemon.getSpecialAttack();//The default setting.
        boolean hasOwner = pokemonEntity.method_35057() != null;//The pokemon has no trainer.
        boolean moveAvailable = move != null;
        if (hasOwner) {
            if (moveAvailable) {
                if (PokemonUtils.isMeleeAttackMove(move)) {
                    setAttackMode(1);
                } else if (PokemonUtils.isRangeAttackMove(move)) {
                    setAttackMode(2);
                } else {
                    setAttackMode(0);
                }
                //CobblemonFightOrFlight.LOGGER.info("Current attack mode: {}", getAttackMode());
                setCurrentMove(move);
            }
        } else {
            if (!attackIsHigher && CobblemonFightOrFlight.commonConfig().wild_pokemon_ranged_attack) {
                setAttackMode(2);
            } else {
                setAttackMode(1);
            }
        }
    }

    @Override
    public void refreshMovesList() {
        if (method_37908().field_9236) {
            return;
        }
        MOVES_FOF.clear();
        Pokemon pokemon = getPokemon();
        for (Move move : pokemon.getMoveSet()) {
            MOVES_FOF.add(new FOFMove(move.getName(), 0, 0));
        }
    }

    @Override
    public void switchMove(Move move) {
        if (method_37908().field_9236 || move == null) {
            return;
        }
        if (MOVES_FOF.isEmpty()) {
            refreshMovesList();
        }
        String oldMoveName = getCurrentMove();
        int index = 0;
        while (index < 4) {
            FOFMove tmpMove = MOVES_FOF.get(index);
            if (tmpMove != null) {
                if (Objects.equals(tmpMove.getName(), oldMoveName)) {
                    tmpMove.setRemainingCooldown(getAttackTime());
                    tmpMove.setOriginalCooldown(getMaxAttackTime());
                    for (int i = 0; i < 4; ++i) {
                        FOFMove m = MOVES_FOF.get(i);
                        if (m != null && Objects.equals(m.getName(), move.getName())) {
                            if (m.getRemainingCooldown() < 10) {
                                setAttackTime(10);
                                setMaxAttackTime(10);
                            } else if (m.getRemainingCooldown() > 10) {
                                setAttackTime(m.getRemainingCooldown());
                                setMaxAttackTime(m.getOriginalCooldown());
                            }
                            break;
                        }
                    }
                    break;
                }
            }
            ++index;
        }
        setCurrentMove(move);
    }

    @Inject(method = "dropAllDeathLoot", at = @At("TAIL"))
    private void dropAllDeathLootInject(class_3218 world, class_1282 source, CallbackInfo ci) {
        if (method_6065() instanceof PokemonEntity pokemonEntity && pokemonEntity.method_35057() != null) {
            PokemonEntity self = (PokemonEntity) (Object) this;
            pokemonEntity.getPokemon().addExperience(new SidemodExperienceSource(CobblemonFightOrFlight.MODID), FOFExpCalculator.calculate(pokemonEntity.getPokemon(), self.getPokemon()));
            if (CobblemonFightOrFlight.commonConfig().can_gain_ev) {
                var map = FOFEVCalculator.calculate(pokemonEntity.getPokemon(), self.getPokemon());
                for (Map.Entry<Stat, Integer> entry : map.entrySet()) {
                    pokemonEntity.getPokemon().getEvs().add(entry.getKey(), entry.getValue());
                }
            }
        }
    }
}
